/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paddle.configuration;

import com.atlassian.paddle.OutputReceiver;
import com.atlassian.paddle.configuration.Configuration;
import com.atlassian.paddle.configuration.ConfigurationException;
import java.io.InputStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class AtlassianUserConfiguration
implements Configuration {
    private Document atlassianUserXml;

    public AtlassianUserConfiguration(InputStream xml) throws ConfigurationException {
        this.setAtlassianUserXml(this.loadDocument(xml));
    }

    private Document loadDocument(InputStream xml) throws ConfigurationException {
        try {
            SAXReader reader = new SAXReader();
            return reader.read(xml);
        }
        catch (DocumentException e) {
            throw new ConfigurationException("Error parsing configuration XML: " + e.getMessage(), e);
        }
    }

    private void setAtlassianUserXml(Document document) throws ConfigurationException {
        if (!this.containsLdapNode(document)) {
            throw new ConfigurationException("No LDAP settings found in XML configuration.");
        }
        this.atlassianUserXml = document;
    }

    private boolean containsLdapNode(Document document) {
        return document.selectSingleNode("//atlassian-user/repositories/ldap") != null;
    }

    public String getAttribute(String attributeName) {
        Node node = this.atlassianUserXml.selectSingleNode("//atlassian-user/repositories/ldap/" + attributeName);
        if (node == null) {
            return null;
        }
        return node.getStringValue();
    }

    public String getAttributeInfoIfMissing(String attributeName, OutputReceiver logger) {
        String value = this.getAttribute(attributeName);
        if (value == null) {
            logger.provideInfoFeedback("Configuration does not have a setting for '" + attributeName + "'");
        }
        return value;
    }
}

