/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paddle.connection;

import com.atlassian.paddle.connection.ConnectionProperties;

public class DefaultConnectionProperties
implements ConnectionProperties {
    public static final String AUTHENTICATION_NONE = "none";
    public static final String AUTHENTICATION_SIMPLE = "simple";
    public static final String AUTHENTICATION_PROTOCOL_PLAIN = "plain";
    private static final int DEFAULT_BATCH_SIZE = 10;
    private final String host;
    private final String port;
    private final String securityAuthentication;
    private final String securityProtocol;
    private final String username;
    private final String password;
    private final int batchSize = 10;

    public DefaultConnectionProperties(String host, String port, String securityAuthentication, String securityProtocol, String username, String password) {
        this.host = host;
        this.port = port;
        this.securityAuthentication = securityAuthentication;
        this.securityProtocol = securityProtocol;
        this.username = username;
        this.password = password;
    }

    public String getProviderUrl() {
        return "ldap://" + this.host + ":" + this.port;
    }

    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public String getBatchSize() {
        return String.valueOf(10);
    }

    public boolean isAnonymousAuthentication() {
        return this.securityAuthentication != null && this.securityAuthentication.equals(AUTHENTICATION_NONE);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSecurityAuthentication() {
        return this.securityAuthentication;
    }
}

