/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paddle.search;

import com.atlassian.paddle.OutputReceiver;
import com.atlassian.paddle.search.ResultConverter;
import com.atlassian.paddle.search.Search;
import com.atlassian.paddle.search.SearchException;
import com.atlassian.paddle.search.Searcher;
import java.util.Collection;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Logger;

public class DefaultSearcher
implements Searcher {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final DirContext context;
    private final long countLimit;
    private OutputReceiver outputReceiver;

    public DefaultSearcher(DirContext context, long countLimit, OutputReceiver outputReceiver) {
        this.context = context;
        this.countLimit = countLimit;
        this.outputReceiver = outputReceiver;
    }

    public Collection search(Search search, ResultConverter resultConverter) throws SearchException {
        String baseDn = search.getBaseDn();
        String filter = search.getFilter();
        SearchControls controls = search.getSearchControls();
        this.outputReceiver.provideDebugFeedback("Limiting maximum number of results to " + this.countLimit + " for " + search);
        controls.setCountLimit(this.countLimit);
        NamingEnumeration<SearchResult> searchResults = null;
        try {
            this.outputReceiver.provideDebugFeedback("Starting LDAP search for " + search);
            long start = System.currentTimeMillis();
            searchResults = this.context.search(baseDn, filter, controls);
            long tookMillis = System.currentTimeMillis() - start;
            this.outputReceiver.provideDebugFeedback("Completed search in " + tookMillis + " ms for " + search);
            Collection results = resultConverter.convert(search, searchResults);
            this.outputReceiver.provideDebugFeedback("Found " + results.size() + " results for " + search);
            Collection collection = results;
            return collection;
        }
        catch (NamingException e) {
            throw new SearchException("Error performing LDAP search " + search + ": " + e.getMessage(), e);
        }
        finally {
            try {
                if (searchResults != null) {
                    searchResults.close();
                }
            }
            catch (NamingException e) {
                this.logger.warn("Could not close search results, possible resource leak", e);
            }
        }
    }
}

