/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paddle.search;

import com.atlassian.paddle.Group;
import com.atlassian.paddle.search.ResultConverter;
import com.atlassian.paddle.search.Search;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchResult;

public class GroupResultConverter
implements ResultConverter {
    private String membershipAttribute;
    private final long memberCountLimit;

    public GroupResultConverter(String membershipAttribute, long memberCountLimit) {
        this.membershipAttribute = membershipAttribute;
        this.memberCountLimit = memberCountLimit;
    }

    public Collection convert(Search search, NamingEnumeration results) {
        HashSet<Group> result = new HashSet<Group>();
        while (results.hasMoreElements()) {
            SearchResult searchResult = (SearchResult)results.nextElement();
            String groupDn = searchResult.getName() + "," + search.getBaseDn();
            Collection members = this.getAttributeValues(searchResult, this.membershipAttribute, this.memberCountLimit);
            result.add(new Group(groupDn, members));
        }
        return result;
    }

    private Collection getAttributeValues(SearchResult searchResult, String attributeName, long countLimit) {
        NamingEnumeration<?> attributeValues;
        LinkedList<String> members = new LinkedList<String>();
        Attribute ldapMembershipAttribute = searchResult.getAttributes().get(attributeName);
        if (ldapMembershipAttribute == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            attributeValues = ldapMembershipAttribute.getAll();
        }
        catch (NamingException e) {
            return Collections.EMPTY_LIST;
        }
        for (long j = 0L; attributeValues.hasMoreElements() && j < countLimit; ++j) {
            String member = (String)attributeValues.nextElement();
            members.add(member);
        }
        return members;
    }
}

