/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paddle.task;

import com.atlassian.paddle.connection.ConnectionException;
import com.atlassian.paddle.connection.ConnectionFactory;
import com.atlassian.paddle.task.Task;
import com.atlassian.paddle.task.TaskRunner;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.log4j.Logger;

public class DefaultTaskRunner
implements TaskRunner {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final ConnectionFactory connectionFactory;
    private final Collection errors = new LinkedList();

    public DefaultTaskRunner(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTask(Task task, long countLimit) throws ConnectionException {
        DirContext context = this.connectionFactory.createConnection();
        try {
            task.withConnection(context, this.errors, countLimit);
        }
        finally {
            try {
                context.close();
            }
            catch (NamingException e) {
                this.logger.warn("Error closing LDAP connection, possible resource leak", e);
            }
        }
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public Iterator getErrorsIterator() {
        return Collections.unmodifiableCollection(this.errors).iterator();
    }

    public void resetErrors() {
        this.errors.clear();
    }
}

