/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paddle.task;

import com.atlassian.paddle.OutputReceiver;
import com.atlassian.paddle.search.DefaultSearcher;
import com.atlassian.paddle.search.DnResultConverter;
import com.atlassian.paddle.search.GroupsForUserSearch;
import com.atlassian.paddle.search.Search;
import com.atlassian.paddle.search.SearchException;
import com.atlassian.paddle.search.Searcher;
import com.atlassian.paddle.search.UsersSearch;
import com.atlassian.paddle.search.properties.GroupSearchProperties;
import com.atlassian.paddle.search.properties.MembershipSearchProperties;
import com.atlassian.paddle.search.properties.UserSearchProperties;
import com.atlassian.paddle.task.Task;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.naming.directory.DirContext;
import org.apache.log4j.Logger;

public class ListUsersTask
implements Task {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final UserSearchProperties userSearchProperties;
    private final MembershipSearchProperties membershipSearchProperties;
    private final GroupSearchProperties groupSearchProperties;
    private final OutputReceiver outputReceiver;

    public ListUsersTask(UserSearchProperties userSearchProperties, MembershipSearchProperties membershipSearchProperties, GroupSearchProperties groupSearchProperties, OutputReceiver outputReceiver) {
        this.userSearchProperties = userSearchProperties;
        this.membershipSearchProperties = membershipSearchProperties;
        this.groupSearchProperties = groupSearchProperties;
        this.outputReceiver = outputReceiver;
    }

    public void withConnection(DirContext context, Collection errors, long countLimit) {
        DefaultSearcher searcher = new DefaultSearcher(context, countLimit, this.outputReceiver);
        Collection userDns = this.doSearch(searcher, errors, new UsersSearch(this.userSearchProperties));
        Iterator userIterator = userDns.iterator();
        while (userIterator.hasNext()) {
            String userDn = (String)userIterator.next();
            this.outputReceiver.provideInfoFeedback("User: " + userDn);
            GroupsForUserSearch groupsSearch = new GroupsForUserSearch(userDn, this.groupSearchProperties, this.membershipSearchProperties);
            Collection groups = this.doSearch(searcher, errors, groupsSearch);
            if (groups.isEmpty()) {
                this.outputReceiver.provideInfoFeedback("\tDoes not belong to any LDAP groups.\n");
                continue;
            }
            this.outputReceiver.provideInfoFeedback("Member of:");
            Iterator groupsIterator = groups.iterator();
            while (groupsIterator.hasNext()) {
                String groupDn = (String)groupsIterator.next();
                this.outputReceiver.provideInfoFeedback("\t" + groupDn);
            }
            this.outputReceiver.provideInfoFeedback("");
        }
    }

    private Collection doSearch(Searcher searcher, Collection errors, Search search) {
        try {
            return searcher.search(search, new DnResultConverter());
        }
        catch (SearchException e) {
            this.logger.debug(e, e);
            errors.add(e.getMessage());
            return Collections.EMPTY_SET;
        }
    }
}

