/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ldaptemplate;

import java.util.List;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import net.sf.ldaptemplate.AttributesMapper;
import net.sf.ldaptemplate.CollectingSearchResultCallbackHandler;
import net.sf.ldaptemplate.ContextExecutor;
import net.sf.ldaptemplate.ContextMapper;
import net.sf.ldaptemplate.ContextSource;
import net.sf.ldaptemplate.DefaultNamingExceptionTranslator;
import net.sf.ldaptemplate.EntryNotFoundException;
import net.sf.ldaptemplate.LdapOperations;
import net.sf.ldaptemplate.NamingExceptionTranslator;
import net.sf.ldaptemplate.SearchExecutor;
import net.sf.ldaptemplate.SearchResultCallbackHandler;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;

public class LdapTemplate
implements LdapOperations,
InitializingBean {
    private static final Log log;
    private static final int DEFAULT_SEARCH_SCOPE = 2;
    private static final boolean DONT_RETURN_OBJ_FLAG = false;
    private static final boolean RETURN_OBJ_FLAG = true;
    private ContextSource contextSource;
    private NamingExceptionTranslator exceptionTranslator = new DefaultNamingExceptionTranslator();
    private boolean ignorePartialResultException = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sf.ldaptemplate.LdapTemplate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog(clazz);
    }

    public LdapTemplate() {
    }

    public LdapTemplate(ContextSource contextSource) {
        this.contextSource = contextSource;
    }

    public void setContextSource(ContextSource contextSource) {
        this.contextSource = contextSource;
    }

    public void setIgnorePartialResultException(boolean ignore) {
        this.ignorePartialResultException = ignore;
    }

    public void search(Name base, String filter, int searchScope, boolean returningObjFlag, SearchResultCallbackHandler handler) {
        this.search(base, filter, this.getDefaultSearchControls(searchScope, returningObjFlag), handler);
    }

    public void search(String base, String filter, int searchScope, boolean returningObjFlag, SearchResultCallbackHandler handler) throws DataAccessException {
        this.search(base, filter, this.getDefaultSearchControls(searchScope, returningObjFlag), handler);
    }

    public void search(final Name base, final String filter, final SearchControls controls, SearchResultCallbackHandler handler) {
        SearchExecutor se = new SearchExecutor(){

            public NamingEnumeration executeSearch(DirContext ctx) throws NamingException {
                return ctx.search(base, filter, controls);
            }
        };
        this.search(se, handler);
    }

    public void search(final String base, final String filter, final SearchControls controls, SearchResultCallbackHandler handler) {
        SearchExecutor se = new SearchExecutor(){

            public NamingEnumeration executeSearch(DirContext ctx) throws NamingException {
                return ctx.search(base, filter, controls);
            }
        };
        this.search(se, handler);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void search(SearchExecutor se, SearchResultCallbackHandler handler) {
        DirContext ctx = this.contextSource.getReadOnlyContext();
        NamingEnumeration results = null;
        try {
            try {
                results = se.executeSearch(ctx);
                while (results.hasMore()) {
                    SearchResult searchResult = (SearchResult)results.next();
                    handler.handleSearchResult(searchResult);
                }
            }
            catch (NameNotFoundException searchResult) {
            }
            catch (PartialResultException e) {
                if (!this.ignorePartialResultException) throw this.getExceptionTranslator().translate(e);
                log.debug("PartialResultException encountered and ignored", e);
            }
            catch (NamingException e) {
                throw this.getExceptionTranslator().translate(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this.closeContextAndNamingEnumeration(ctx, results);
            throw throwable;
        }
        {
            Object var6_11 = null;
            this.closeContextAndNamingEnumeration(ctx, results);
            return;
        }
    }

    public void search(Name base, String filter, SearchResultCallbackHandler handler) throws DataAccessException {
        this.search(base, filter, this.getDefaultSearchControls(2, false), handler);
    }

    public void search(String base, String filter, SearchResultCallbackHandler handler) throws DataAccessException {
        this.search(base, filter, this.getDefaultSearchControls(2, false), handler);
    }

    public List search(Name base, String filter, int searchScope, AttributesMapper mapper) {
        return this.search(base, filter, this.getDefaultSearchControls(searchScope, false), mapper);
    }

    public List search(String base, String filter, int searchScope, AttributesMapper mapper) throws DataAccessException {
        return this.search(base, filter, this.getDefaultSearchControls(searchScope, false), mapper);
    }

    public List search(Name base, String filter, AttributesMapper mapper) throws DataAccessException {
        return this.search(base, filter, 2, mapper);
    }

    public List search(String base, String filter, AttributesMapper mapper) throws DataAccessException {
        return this.search(base, filter, 2, mapper);
    }

    public List search(Name base, String filter, int searchScope, ContextMapper mapper) {
        return this.search(base, filter, this.getDefaultSearchControls(searchScope, true), mapper);
    }

    public List search(String base, String filter, int searchScope, ContextMapper mapper) throws DataAccessException {
        return this.search(base, filter, this.getDefaultSearchControls(searchScope, true), mapper);
    }

    public List search(Name base, String filter, ContextMapper mapper) throws DataAccessException {
        return this.search(base, filter, 2, mapper);
    }

    public List search(String base, String filter, ContextMapper mapper) throws DataAccessException {
        return this.search(base, filter, 2, mapper);
    }

    public List search(String base, String filter, SearchControls controls, ContextMapper mapper) {
        this.assureReturnObjFlagSet(controls);
        ContextMapperCallbackHandler handler = new ContextMapperCallbackHandler(mapper);
        this.search(base, filter, controls, (SearchResultCallbackHandler)handler);
        return handler.getList();
    }

    public List search(Name base, String filter, SearchControls controls, ContextMapper mapper) {
        this.assureReturnObjFlagSet(controls);
        ContextMapperCallbackHandler handler = new ContextMapperCallbackHandler(mapper);
        this.search(base, filter, controls, (SearchResultCallbackHandler)handler);
        return handler.getList();
    }

    public List search(Name base, String filter, SearchControls controls, AttributesMapper mapper) {
        AttributesMapperCallbackHandler handler = new AttributesMapperCallbackHandler(mapper);
        this.search(base, filter, controls, (SearchResultCallbackHandler)handler);
        return handler.getList();
    }

    public List search(String base, String filter, SearchControls controls, AttributesMapper mapper) {
        AttributesMapperCallbackHandler handler = new AttributesMapperCallbackHandler(mapper);
        this.search(base, filter, controls, (SearchResultCallbackHandler)handler);
        return handler.getList();
    }

    public Object executeReadOnly(ContextExecutor ce) {
        DirContext ctx = this.contextSource.getReadOnlyContext();
        return this.executeWithContext(ce, ctx);
    }

    public Object executeReadWrite(ContextExecutor ce) {
        DirContext ctx = this.contextSource.getReadWriteContext();
        return this.executeWithContext(ce, ctx);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object executeWithContext(ContextExecutor ce, DirContext ctx) {
        try {
            try {
                Object object = ce.executeWithContext(ctx);
                Object var4_4 = null;
                this.closeContext(ctx);
                return object;
            }
            catch (NamingException e) {
                throw this.getExceptionTranslator().translate(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.closeContext(ctx);
            throw throwable;
        }
    }

    public Object lookup(final Name dn) {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                return ctx.lookup(dn);
            }
        });
    }

    public Object lookup(final String dn) throws DataAccessException {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                return ctx.lookup(dn);
            }
        });
    }

    public Object lookup(final Name dn, final AttributesMapper mapper) {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                Attributes attributes = ctx.getAttributes(dn);
                return mapper.mapFromAttributes(attributes);
            }
        });
    }

    public Object lookup(final String dn, final AttributesMapper mapper) throws DataAccessException {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                Attributes attributes = ctx.getAttributes(dn);
                return mapper.mapFromAttributes(attributes);
            }
        });
    }

    public Object lookup(final Name dn, final ContextMapper mapper) {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                Object object = ctx.lookup(dn);
                return mapper.mapFromContext(object);
            }
        });
    }

    public Object lookup(final String dn, final ContextMapper mapper) throws DataAccessException {
        return this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                Object object = ctx.lookup(dn);
                return mapper.mapFromContext(object);
            }
        });
    }

    public void modifyAttributes(final Name dn, final ModificationItem[] mods) {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                ctx.modifyAttributes(dn, mods);
                return null;
            }
        });
    }

    public void modifyAttributes(final String dn, final ModificationItem[] mods) throws DataAccessException {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                ctx.modifyAttributes(dn, mods);
                return null;
            }
        });
    }

    public void bind(final Name dn, final Object obj, final Attributes attributes) {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                ctx.bind(dn, obj, attributes);
                return null;
            }
        });
    }

    public void bind(final String dn, final Object obj, final Attributes attributes) throws DataAccessException {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                ctx.bind(dn, obj, attributes);
                return null;
            }
        });
    }

    public void unbind(final Name dn) {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                ctx.unbind(dn);
                return null;
            }
        });
    }

    public void unbind(final String dn) throws DataAccessException {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                ctx.unbind(dn);
                return null;
            }
        });
    }

    public void rebind(final Name dn, final Object obj, final Attributes attributes) throws DataAccessException {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                ctx.rebind(dn, obj, attributes);
                return null;
            }
        });
    }

    public void rebind(final String dn, final Object obj, final Attributes attributes) throws DataAccessException {
        this.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                ctx.rebind(dn, obj, attributes);
                return null;
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        if (this.contextSource == null) {
            throw new IllegalArgumentException("Property 'contextSource' must be set.");
        }
    }

    private void closeContextAndNamingEnumeration(DirContext ctx, NamingEnumeration results) {
        this.closeNamingEnumeration(results);
        this.closeContext(ctx);
    }

    private void closeContext(DirContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeNamingEnumeration(NamingEnumeration results) {
        if (results != null) {
            try {
                results.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public NamingExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }

    public void setExceptionTranslator(NamingExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
    }

    private SearchControls getDefaultSearchControls(int searchScope, boolean returningObjFlag) {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(searchScope);
        controls.setReturningObjFlag(returningObjFlag);
        return controls;
    }

    private void assureReturnObjFlagSet(SearchControls controls) {
        Validate.notNull(controls);
        if (!controls.getReturningObjFlag()) {
            log.info("The returnObjFlag of supplied SearchControls is not set but a ContextMapper is used - setting flag to true");
            controls.setReturningObjFlag(true);
        }
    }

    public class AttributesMapperCallbackHandler
    extends CollectingSearchResultCallbackHandler {
        private AttributesMapper mapper;

        public AttributesMapperCallbackHandler(AttributesMapper mapper) {
            this.mapper = mapper;
        }

        protected Object getObjectFromResult(SearchResult searchResult) {
            Attributes attributes = searchResult.getAttributes();
            try {
                return this.mapper.mapFromAttributes(attributes);
            }
            catch (NamingException e) {
                throw LdapTemplate.this.getExceptionTranslator().translate(e);
            }
        }
    }

    public class ContextMapperCallbackHandler
    extends CollectingSearchResultCallbackHandler {
        private ContextMapper mapper;

        public ContextMapperCallbackHandler(ContextMapper mapper) {
            this.mapper = mapper;
        }

        protected Object getObjectFromResult(SearchResult searchResult) {
            Object object = searchResult.getObject();
            if (object == null) {
                throw new EntryNotFoundException("SearchResult did not contain any object.");
            }
            return this.mapper.mapFromContext(object);
        }
    }
}

