/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ldaptemplate.support;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import net.sf.ldaptemplate.DefaultNamingExceptionTranslator;
import net.sf.ldaptemplate.NamingExceptionTranslator;
import net.sf.ldaptemplate.support.DirContextOperations;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DirContextAdapter
implements DirContextOperations {
    private static final boolean ORDER_DOESNT_MATTER = false;
    private static Log log;
    private final Attributes attrs;
    private Name dn;
    private boolean updateMode = false;
    private Attributes updatedAttrs;
    private NamingExceptionTranslator exceptionTranslator;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sf.ldaptemplate.support.DirContextAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog(clazz);
    }

    public DirContextAdapter() {
        this.attrs = new BasicAttributes(true);
        this.dn = null;
    }

    public DirContextAdapter(Name dn) {
        this.attrs = new BasicAttributes(true);
        this.dn = dn;
    }

    public DirContextAdapter(Attributes pAttrs, Name dn) {
        this.attrs = (Attributes)pAttrs.clone();
        this.dn = dn;
    }

    protected DirContextAdapter(DirContextAdapter master) {
        this.attrs = (Attributes)master.attrs.clone();
        this.dn = master.dn;
        this.updatedAttrs = (Attributes)master.updatedAttrs.clone();
        this.updateMode = master.updateMode;
    }

    protected void setUpdateMode(boolean mode) {
        this.updateMode = mode;
        if (this.updateMode) {
            this.updatedAttrs = new BasicAttributes(true);
        }
    }

    public boolean isUpdateMode() {
        return this.updateMode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getNamesOfModifiedAttributes() {
        ArrayList<String> tmpList = new ArrayList<String>();
        NamingEnumeration<? extends Attribute> attributesEnumeration = this.isUpdateMode() ? this.updatedAttrs.getAll() : this.attrs.getAll();
        try {
            try {
                while (attributesEnumeration.hasMore()) {
                    Attribute oneAttribute = attributesEnumeration.next();
                    tmpList.add(oneAttribute.getID());
                }
            }
            catch (NamingException e) {
                throw this.getExceptionTranslator().translate(e);
            }
            Object var4_7 = null;
            this.closeNamingEnumeration(attributesEnumeration);
            return tmpList.toArray(new String[0]);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.closeNamingEnumeration(attributesEnumeration);
            throw throwable;
        }
    }

    private void closeNamingEnumeration(NamingEnumeration enumeration) {
        try {
            if (enumeration != null) {
                enumeration.close();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModificationItem[] getModificationItems() {
        if (!this.updateMode) {
            return new ModificationItem[0];
        }
        ArrayList<ModificationItem> tmpList = new ArrayList<ModificationItem>();
        NamingEnumeration<? extends Attribute> attributesEnumeration = null;
        try {
            try {
                attributesEnumeration = this.updatedAttrs.getAll();
                while (attributesEnumeration.hasMore()) {
                    ModificationItem mod;
                    Attribute oneAttr = attributesEnumeration.next();
                    if (this.exists(oneAttr)) {
                        if (oneAttr.size() == 0 || oneAttr.get(0) == null) {
                            if (log.isDebugEnabled()) {
                                this.logAttribute("Add REMOVE_ATTRIBUTE modification", oneAttr);
                            }
                            mod = new ModificationItem(3, oneAttr);
                        } else {
                            if (log.isDebugEnabled()) {
                                this.logAttribute("Add REPLACE_ATTRIBUTE modification", oneAttr);
                            }
                            mod = new ModificationItem(2, oneAttr);
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            this.logAttribute("Add ADD_ATTRIBUTE modification", oneAttr);
                        }
                        mod = new ModificationItem(1, oneAttr);
                    }
                    tmpList.add(mod);
                }
            }
            catch (NamingException e) {
                throw this.getExceptionTranslator().translate(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.closeNamingEnumeration(attributesEnumeration);
            throw throwable;
        }
        {
            Object var5_8 = null;
            this.closeNamingEnumeration(attributesEnumeration);
            if (log.isDebugEnabled()) {
                log.debug("Number of modifications:" + tmpList.size());
            }
            return tmpList.toArray(new ModificationItem[tmpList.size()]);
        }
    }

    private void logAttribute(String msg, Attribute attr) {
        StringBuffer buf = new StringBuffer();
        try {
            NamingEnumeration<?> attributes = attr.getAll();
            while (attributes.hasMore()) {
                Object obj = attributes.next();
                buf.append(obj);
                if (!attributes.hasMore()) continue;
                buf.append(",");
            }
            attributes.close();
        }
        catch (NamingException e) {
            log.warn("Failed to log attribute");
        }
        log.info(String.valueOf(msg) + ",attr id:" + attr.getID() + ", val:" + buf.toString());
    }

    private boolean isChanged(String name, Object value) {
        Attribute a = this.attrs.get(name);
        if (a == null && value == null) {
            return false;
        }
        if (a == null || a.size() != 1) {
            return true;
        }
        if (a != null && value == null) {
            return true;
        }
        Object obj = null;
        try {
            obj = a.get(0);
        }
        catch (NamingException e) {
            return true;
        }
        return !value.equals(obj);
    }

    private boolean isEmptyAttribute(Attribute a) {
        try {
            return a == null || a.size() == 0 || a.get() == null;
        }
        catch (NamingException e) {
            return true;
        }
    }

    private boolean isChanged(String name, Object[] values, boolean orderMatters) {
        boolean emptyNewValue;
        Attribute a = this.attrs.get(name);
        boolean bl = emptyNewValue = values == null || values.length == 0;
        if (emptyNewValue) {
            return a != null;
        }
        if (a == null) {
            return true;
        }
        if (a.size() != values.length) {
            return true;
        }
        try {
            int i = 0;
            while (i < a.size()) {
                Object obj = a.get(i);
                if (!(obj instanceof String)) {
                    return true;
                }
                if (orderMatters ? !values[i].equals(obj) : !ArrayUtils.contains(values, obj)) {
                    return true;
                }
                ++i;
            }
        }
        catch (NamingException e) {
            return true;
        }
        return false;
    }

    protected final boolean exists(Attribute attr) {
        return this.exists(attr.getID());
    }

    protected final boolean exists(String attrId) {
        return this.attrs.get(attrId) != null;
    }

    public String getStringAttribute(String name) {
        return (String)this.getObjectAttribute(name);
    }

    public Object getObjectAttribute(String name) {
        Attribute oneAttr = this.attrs.get(name);
        if (oneAttr == null) {
            return null;
        }
        try {
            return oneAttr.get();
        }
        catch (NamingException e) {
            throw this.getExceptionTranslator().translate(e);
        }
    }

    public void setAttributeValue(String name, Object value) {
        if (!this.updateMode && value != null) {
            this.attrs.put(name, value);
        }
        if (this.updateMode && this.isChanged(name, value)) {
            this.updatedAttrs.put(name, value);
        }
    }

    public void setAttributeValues(String name, Object[] values) {
        this.setAttributeValues(name, values, false);
    }

    public void setAttributeValues(String name, Object[] values, boolean orderMatters) {
        BasicAttribute a = new BasicAttribute(name, orderMatters);
        int i = 0;
        while (values != null && i < values.length) {
            a.add(values[i]);
            ++i;
        }
        if (!this.updateMode && values != null && values.length > 0) {
            this.attrs.put(a);
        }
        if (this.updateMode && this.isChanged(name, values, orderMatters)) {
            this.updatedAttrs.put(a);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update() {
        NamingEnumeration<? extends Attribute> attributesEnumeration = null;
        try {
            try {
                attributesEnumeration = this.updatedAttrs.getAll();
                while (attributesEnumeration.hasMore()) {
                    Attribute a = attributesEnumeration.next();
                    if (this.isEmptyAttribute(a)) {
                        this.attrs.remove(a.getID());
                        continue;
                    }
                    this.attrs.put(a);
                }
            }
            catch (NamingException e) {
                throw this.getExceptionTranslator().translate(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.closeNamingEnumeration(attributesEnumeration);
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.closeNamingEnumeration(attributesEnumeration);
            this.updatedAttrs = new BasicAttributes(true);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String[] getStringAttributes(String name) {
        void var2_3;
        Attribute attribute = this.attrs.get(name);
        if (attribute != null && attribute.size() > 0) {
            String[] attributes = new String[attribute.size()];
            int i = 0;
            while (i < attribute.size()) {
                try {
                    attributes[i] = (String)attribute.get(i);
                }
                catch (NamingException e) {
                    throw this.getExceptionTranslator().translate(e);
                }
                ++i;
            }
        } else {
            return null;
        }
        return var2_3;
    }

    public SortedSet getAttributeSortedStringSet(String name) {
        TreeSet<Object> attrSet = new TreeSet<Object>();
        Attribute attribute = this.attrs.get(name);
        if (attribute != null) {
            int i = 0;
            while (i < attribute.size()) {
                try {
                    attrSet.add(attribute.get(i));
                }
                catch (NamingException e) {
                    throw this.getExceptionTranslator().translate(e);
                }
                ++i;
            }
        } else {
            return null;
        }
        return attrSet;
    }

    public void setAttribute(Attribute attribute) {
        this.attrs.put(attribute);
    }

    public Attributes getAttributes() {
        return this.attrs;
    }

    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name.toString());
    }

    public Attributes getAttributes(String name) throws NamingException {
        if (!StringUtils.isEmpty(name)) {
            throw new NameNotFoundException();
        }
        return (Attributes)this.attrs.clone();
    }

    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        return this.getAttributes(name.toString(), attrIds);
    }

    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        if (!StringUtils.isEmpty(name)) {
            throw new NameNotFoundException();
        }
        BasicAttributes a = new BasicAttributes(true);
        int i = 0;
        while (i < attrIds.length) {
            Attribute target = this.attrs.get(attrIds[i]);
            if (target != null) {
                a.put(target);
            }
            ++i;
        }
        return a;
    }

    public void modifyAttributes(Name name, int modOp, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void modifyAttributes(String name, int modOp, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public DirContext getSchema(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public DirContext getSchema(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(Name name, String filter, SearchControls cons) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Object lookup(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Object lookup(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void bind(Name name, Object obj) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void bind(String name, Object obj) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void rebind(Name name, Object obj) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void rebind(String name, Object obj) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void unbind(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void unbind(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void rename(String oldName, String newName) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration list(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Object lookupLink(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Object lookupLink(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NameParser getNameParser(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NameParser getNameParser(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public String composeName(String name, String prefix) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Hashtable getEnvironment() throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void close() throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public String getNameInNamespace() {
        return this.dn.toString();
    }

    public Name getDn() {
        return this.dn;
    }

    public final void setDn(Name dn) {
        if (!this.updateMode) {
            this.dn = dn;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return EqualsBuilder.reflectionEquals(this, obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName());
        buf.append(":");
        if (this.dn != null) {
            buf.append(" dn=" + this.dn);
        }
        buf.append(" {");
        try {
            NamingEnumeration<? extends Attribute> i = this.attrs.getAll();
            while (i.hasMore()) {
                Attribute attribute = i.next();
                if (attribute.size() == 1) {
                    buf.append(attribute.getID());
                    buf.append('=');
                    buf.append(attribute.get());
                } else {
                    int j = 0;
                    while (j < attribute.size()) {
                        if (j > 0) {
                            buf.append(", ");
                        }
                        buf.append(attribute.getID());
                        buf.append('[');
                        buf.append(j);
                        buf.append("]=");
                        buf.append(attribute.get(j));
                        ++j;
                    }
                }
                if (!i.hasMore()) continue;
                buf.append(", ");
            }
        }
        catch (NamingException e) {
            log.warn("Error in toString()");
        }
        buf.append('}');
        return buf.toString();
    }

    public NamingExceptionTranslator getExceptionTranslator() {
        if (this.exceptionTranslator == null) {
            this.exceptionTranslator = new DefaultNamingExceptionTranslator();
        }
        return this.exceptionTranslator;
    }

    public void setExceptionTranslator(NamingExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
    }
}

