/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ldaptemplate.support;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import net.sf.ldaptemplate.BadLdapGrammarException;
import net.sf.ldaptemplate.support.LdapRdn;
import org.apache.commons.lang.StringUtils;

public class DistinguishedName
implements Name {
    private static final long serialVersionUID = 3514344371999042586L;
    public static final DistinguishedName EMPTY_PATH = new DistinguishedName();
    private LinkedList names;
    protected static final Pattern NAME_PATTERN = Pattern.compile("(.*?[^\\\\])(,|;|$)");

    public DistinguishedName() {
        this.names = new LinkedList();
    }

    public DistinguishedName(String path) {
        this.parse(path);
    }

    public DistinguishedName(LinkedList list) {
        this.names = list;
    }

    public DistinguishedName(Name name) {
        this.names = new LinkedList();
        int i = 0;
        while (i < name.size()) {
            this.names.add(new LdapRdn(name.get(i)));
            ++i;
        }
    }

    protected void parse(String path) {
        this.names = new LinkedList();
        if (!StringUtils.isBlank(path)) {
            Matcher matcher = NAME_PATTERN.matcher(path);
            while (matcher.find()) {
                String rdnString = matcher.group(1);
                LdapRdn name = new LdapRdn(rdnString);
                this.names.add(0, name);
            }
        }
    }

    public LdapRdn getLdapRdn(int index) {
        return (LdapRdn)this.names.get(index);
    }

    public LinkedList getNames() {
        return this.names;
    }

    public String toString() {
        return this.encode();
    }

    public String encode() {
        if (this.names.size() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(256);
        ListIterator i = this.names.listIterator(this.names.size());
        while (i.hasPrevious()) {
            LdapRdn rdn = (LdapRdn)i.previous();
            buffer.append(rdn.getLdapEncoded());
            if (!i.hasPrevious()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    public String toUrl() {
        StringBuffer buffer = new StringBuffer(256);
        int i = this.names.size() - 1;
        while (i >= 0) {
            LdapRdn n = (LdapRdn)this.names.get(i);
            buffer.append(n.encodeUrl());
            if (i > 0) {
                buffer.append(",");
            }
            --i;
        }
        return buffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    public boolean contains(DistinguishedName path) {
        shortlist = path.getNames();
        if (this.getNames().size() < shortlist.size()) {
            return false;
        }
        if (shortlist.size() == 0) {
            return false;
        }
        longiter = this.getNames().iterator();
        shortiter = shortlist.iterator();
        longname = (LdapRdn)longiter.next();
        shortname = (LdapRdn)shortiter.next();
        while (!longname.equals(shortname) && longiter.hasNext()) {
            longname = (LdapRdn)longiter.next();
        }
        if (!shortiter.hasNext() && longname.equals(shortname)) {
            return true;
        }
        if (longiter.hasNext()) ** GOTO lbl19
        return false;
lbl-1000:
        // 1 sources

        {
            longname = (LdapRdn)longiter.next();
            shortname = (LdapRdn)shortiter.next();
lbl19:
            // 2 sources

            ** while (longname.equals((Object)shortname) && longiter.hasNext() && shortiter.hasNext())
        }
lbl20:
        // 1 sources

        return shortiter.hasNext() == false && longname.equals(shortname) != false;
    }

    public void append(DistinguishedName path) {
        this.getNames().addAll(path.getNames());
    }

    public void prepend(DistinguishedName path) {
        ListIterator i = path.getNames().listIterator(path.getNames().size());
        while (i.hasPrevious()) {
            this.getNames().addFirst(i.previous());
        }
    }

    public LdapRdn removeFirst() {
        return (LdapRdn)this.getNames().removeFirst();
    }

    public void removeFirst(Name path) {
        if (path != null && this.startsWith(path)) {
            int i = 0;
            while (i < path.size()) {
                this.removeFirst();
                ++i;
            }
        }
    }

    public Object clone() {
        LinkedList list = new LinkedList(this.getNames());
        return new DistinguishedName(list);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DistinguishedName name = (DistinguishedName)obj;
        return this.getNames().equals(name.getNames());
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.getNames().hashCode();
    }

    public int compareTo(Object o) {
        return 0;
    }

    public int size() {
        return this.names.size();
    }

    public boolean isEmpty() {
        return this.names.size() == 0;
    }

    public Enumeration getAll() {
        LinkedList<String> strings = new LinkedList<String>();
        Iterator iter = this.names.iterator();
        while (iter.hasNext()) {
            LdapRdn rdn = (LdapRdn)iter.next();
            strings.add(rdn.getLdapEncoded());
        }
        return Collections.enumeration(strings);
    }

    public String get(int index) {
        LdapRdn rdn = (LdapRdn)this.names.get(index);
        return rdn.getLdapEncoded();
    }

    public Name getPrefix(int index) {
        LinkedList newNames = new LinkedList();
        int i = 0;
        while (i <= index) {
            newNames.add(this.names.get(i));
            ++i;
        }
        return new DistinguishedName(newNames);
    }

    public Name getSuffix(int index) {
        if (index > this.names.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        LinkedList newNames = new LinkedList();
        int i = index;
        while (i < this.names.size()) {
            newNames.add(this.names.get(i));
            ++i;
        }
        return new DistinguishedName(newNames);
    }

    public boolean startsWith(Name name) {
        if (name.size() == 0) {
            return false;
        }
        DistinguishedName start = null;
        if (!(name instanceof DistinguishedName)) {
            return false;
        }
        start = (DistinguishedName)name;
        if (start.size() > this.size()) {
            return false;
        }
        Iterator longiter = this.names.iterator();
        Iterator shortiter = start.getNames().iterator();
        while (shortiter.hasNext()) {
            Object shortname;
            Object longname = longiter.next();
            if (longname.equals(shortname = shortiter.next())) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(Name name) {
        DistinguishedName path = null;
        if (!(name instanceof DistinguishedName)) {
            return false;
        }
        path = (DistinguishedName)name;
        LinkedList shortlist = path.getNames();
        if (this.getNames().size() < shortlist.size()) {
            return false;
        }
        if (shortlist.size() == 0) {
            return false;
        }
        ListIterator longiter = this.getNames().listIterator(this.getNames().size());
        ListIterator shortiter = shortlist.listIterator(shortlist.size());
        while (shortiter.hasPrevious()) {
            LdapRdn shortname;
            LdapRdn longname = (LdapRdn)longiter.previous();
            if (longname.equals(shortname = (LdapRdn)shortiter.previous())) continue;
            return false;
        }
        return true;
    }

    public Name addAll(Name name) throws InvalidNameException {
        return this.addAll(this.names.size(), name);
    }

    public Name addAll(int arg0, Name name) throws InvalidNameException {
        DistinguishedName distinguishedName = null;
        try {
            distinguishedName = (DistinguishedName)name;
        }
        catch (ClassCastException e) {
            throw new InvalidNameException("Invalid name type");
        }
        this.names.addAll(arg0, distinguishedName.getNames());
        return this;
    }

    public Name add(String string) throws InvalidNameException {
        return this.add(this.names.size(), string);
    }

    public Name add(int index, String string) throws InvalidNameException {
        try {
            this.names.add(index, new LdapRdn(string));
        }
        catch (BadLdapGrammarException e) {
            throw new InvalidNameException("Failed to parse rdn '" + string + "'");
        }
        return this;
    }

    public Object remove(int arg0) throws InvalidNameException {
        LdapRdn rdn = (LdapRdn)this.names.remove(arg0);
        return rdn.getLdapEncoded();
    }

    public LdapRdn removeLast() {
        return (LdapRdn)this.getNames().removeLast();
    }

    public void add(String key, String value) {
        this.names.add(new LdapRdn(key, value));
    }
}

