/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ldaptemplate.support;

import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.InitialLdapContext;
import net.sf.ldaptemplate.AuthenticationSource;
import net.sf.ldaptemplate.ContextSource;
import net.sf.ldaptemplate.DefaultNamingExceptionTranslator;
import net.sf.ldaptemplate.NamingExceptionTranslator;
import net.sf.ldaptemplate.support.DistinguishedName;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.JdkVersion;

public class LdapContextSource
implements ContextSource,
InitializingBean {
    private static final Class DEFAULT_CONTEXT_FACTORY;
    private Class dirObjectFactory;
    private Class contextFactory = DEFAULT_CONTEXT_FACTORY;
    private DistinguishedName base;
    private String userName = "";
    private String password = "";
    private String[] urls;
    private boolean pooled = true;
    private boolean authenticatedReadOnly = false;
    private Hashtable baseEnv = new Hashtable();
    private Hashtable anonymousEnv;
    private AuthenticationSource authenticationSource;
    private boolean cacheEnvironmentProperties = true;
    private NamingExceptionTranslator exceptionTranslator = new DefaultNamingExceptionTranslator();
    private static final Log log;
    public static final String SUN_LDAP_POOLING_FLAG = "com.sun.jndi.ldap.connect.pool";
    private static final String JDK_142 = "1.4.2";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sun.jndi.ldap.LdapCtxFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DEFAULT_CONTEXT_FACTORY = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("net.sf.ldaptemplate.support.LdapContextSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog(clazz2);
    }

    public DirContext getReadOnlyContext() {
        if (this.authenticatedReadOnly) {
            return this.createContext(this.getAuthenticatedEnv());
        }
        return this.createContext(this.getAnonymousEnv());
    }

    public DirContext getReadWriteContext() {
        return this.createContext(this.getAuthenticatedEnv());
    }

    protected void setupAuthenticatedEnvironment(Hashtable env) {
        env.put("java.naming.security.principal", this.authenticationSource.getPrincipal());
        log.debug("Principal: '" + this.userName + "'");
        env.put("java.naming.security.credentials", this.authenticationSource.getCredentials());
    }

    private void closeContext(DirContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected String assembleProviderUrlString(String[] ldapUrls) {
        StringBuffer providerUrlBuffer = new StringBuffer(1024);
        int i = 0;
        while (i < ldapUrls.length) {
            providerUrlBuffer.append(ldapUrls[i]);
            if (this.base != null) {
                if (!ldapUrls[i].endsWith("/")) {
                    providerUrlBuffer.append("/");
                }
                providerUrlBuffer.append(this.base.toUrl());
            }
            providerUrlBuffer.append(' ');
            ++i;
        }
        return providerUrlBuffer.toString().trim();
    }

    public void setBase(String base) {
        this.base = new DistinguishedName(base);
    }

    DirContext createContext(Hashtable environment) {
        DirContext ctx = null;
        try {
            ctx = this.getDirContextInstance(environment);
            if (log.isInfoEnabled()) {
                Hashtable<?, ?> ctxEnv = ctx.getEnvironment();
                String ldapUrl = (String)ctxEnv.get("java.naming.provider.url");
                log.debug("Got Ldap context on server '" + ldapUrl + "'");
            }
            return ctx;
        }
        catch (NamingException e) {
            this.closeContext(ctx);
            throw this.getExceptionTranslator().translate(e);
        }
    }

    protected DirContext getDirContextInstance(Hashtable environment) throws NamingException {
        return new InitialLdapContext(environment, null);
    }

    public void setContextFactory(Class contextFactory) {
        this.contextFactory = contextFactory;
    }

    public void setDirObjectFactory(Class dirObjectFactory) {
        this.dirObjectFactory = dirObjectFactory;
    }

    public void afterPropertiesSet() throws Exception {
        if (ArrayUtils.isEmpty(this.urls)) {
            throw new IllegalArgumentException("At least one server url must be set");
        }
        if (this.base != null && this.getJdkVersion().compareTo(JDK_142) <= 0) {
            throw new IllegalArgumentException("Base path is not supported for JDK versions < 1.4.2");
        }
        if (this.authenticationSource == null) {
            log.debug("AuthenticationSource not set - using default implementation");
            if (StringUtils.isBlank(this.userName)) {
                log.warn("Property 'userName' not set - anonymous context will be used for read-write operations");
            } else if (StringUtils.isBlank(this.password)) {
                log.warn("Property 'password' not set - blank password will be used");
            }
            this.authenticationSource = new SimpleAuthenticationSource();
        }
        if (this.cacheEnvironmentProperties) {
            this.anonymousEnv = this.setupAnonymousEnv();
        }
    }

    private Hashtable setupAnonymousEnv() {
        if (this.pooled) {
            this.baseEnv.put(SUN_LDAP_POOLING_FLAG, "true");
            log.debug("Using LDAP pooling.");
        } else {
            log.debug("Not using LDAP pooling");
        }
        Hashtable<String, Object> env = new Hashtable<String, Object>(this.baseEnv);
        env.put("java.naming.factory.initial", this.contextFactory.getName());
        env.put("java.naming.provider.url", this.assembleProviderUrlString(this.urls));
        if (this.dirObjectFactory != null) {
            env.put("java.naming.factory.object", this.dirObjectFactory.getName());
        }
        if (this.base != null) {
            env.put("net.sf.ldaptemplate.base.path", this.base);
        }
        log.debug("Trying provider Urls: " + this.assembleProviderUrlString(this.urls));
        return env;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setUrls(String[] urls) {
        this.urls = urls;
    }

    public void setUrl(String url) {
        this.urls = new String[]{url};
    }

    public void setPooled(boolean pooled) {
        this.pooled = pooled;
    }

    public void setBaseEnvironmentProperties(Map baseEnvironmentProperties) {
        this.baseEnv = new Hashtable(baseEnvironmentProperties);
    }

    String getJdkVersion() {
        return JdkVersion.getJavaVersion();
    }

    protected Hashtable getAnonymousEnv() {
        if (this.cacheEnvironmentProperties) {
            return this.anonymousEnv;
        }
        return this.setupAnonymousEnv();
    }

    protected Hashtable getAuthenticatedEnv() {
        Hashtable env = new Hashtable(this.getAnonymousEnv());
        this.setupAuthenticatedEnvironment(env);
        return env;
    }

    public void setAuthenticatedReadOnly(boolean authenticatedReadOnly) {
        this.authenticatedReadOnly = authenticatedReadOnly;
    }

    public void setAuthenticationSource(AuthenticationSource authenticationProvider) {
        this.authenticationSource = authenticationProvider;
    }

    public void setCacheEnvironmentProperties(boolean cacheEnvironmentProperties) {
        this.cacheEnvironmentProperties = cacheEnvironmentProperties;
    }

    public void setExceptionTranslator(NamingExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
    }

    public NamingExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }

    private class SimpleAuthenticationSource
    implements AuthenticationSource {
        SimpleAuthenticationSource() {
        }

        public String getPrincipal() {
            return LdapContextSource.this.userName;
        }

        public String getCredentials() {
            return LdapContextSource.this.password;
        }
    }
}

