/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ldaptemplate.support;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.ldaptemplate.BadLdapGrammarException;
import org.apache.commons.lang.StringUtils;

public class LdapEncoder {
    private static String[] nameEscapeTable = new String[96];
    private static String[] filterEscapeTable = new String[93];
    private static final Pattern VALUE_DECODE_PATTERN = Pattern.compile("(?:\\\\(\\p{XDigit}{2}))|(?:\\\\(.))|([^\\\\])");

    static {
        char c = '\u0000';
        while (c < ' ') {
            LdapEncoder.nameEscapeTable[c] = "\\" + LdapEncoder.toTwoCharHex(c);
            c = (char)(c + '\u0001');
        }
        LdapEncoder.nameEscapeTable[35] = "\\#";
        LdapEncoder.nameEscapeTable[44] = "\\,";
        LdapEncoder.nameEscapeTable[59] = "\\;";
        LdapEncoder.nameEscapeTable[61] = "\\=";
        LdapEncoder.nameEscapeTable[43] = "\\+";
        LdapEncoder.nameEscapeTable[60] = "\\<";
        LdapEncoder.nameEscapeTable[62] = "\\>";
        LdapEncoder.nameEscapeTable[34] = "\\\"";
        LdapEncoder.nameEscapeTable[92] = "\\\\";
        c = '\u0000';
        while (c < filterEscapeTable.length) {
            LdapEncoder.filterEscapeTable[c] = String.valueOf(c);
            c = (char)(c + '\u0001');
        }
        LdapEncoder.filterEscapeTable[42] = "\\2a";
        LdapEncoder.filterEscapeTable[40] = "\\28";
        LdapEncoder.filterEscapeTable[41] = "\\29";
        LdapEncoder.filterEscapeTable[92] = "\\5c";
        LdapEncoder.filterEscapeTable[0] = "\\00";
    }

    protected static String toTwoCharHex(char c) {
        String raw = Integer.toHexString(c).toUpperCase();
        if (raw.length() > 1) {
            return raw;
        }
        return "0" + raw;
    }

    private LdapEncoder() {
    }

    public static String filterEncode(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer encodedValue = new StringBuffer(value.length() * 2);
        int length = value.length();
        int i = 0;
        while (i < length) {
            char c = value.charAt(i);
            if (c < filterEscapeTable.length) {
                encodedValue.append(filterEscapeTable[c]);
            } else {
                encodedValue.append(c);
            }
            ++i;
        }
        return encodedValue.toString();
    }

    public static String nameEncode(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer encodedValue = new StringBuffer(value.length() * 2);
        int length = value.length();
        int last = length - 1;
        int i = 0;
        while (i < length) {
            String esc;
            char c = value.charAt(i);
            if (c == ' ' && (i == 0 || i == last)) {
                encodedValue.append("\\ ");
            } else if (c < nameEscapeTable.length && (esc = nameEscapeTable[c]) != null) {
                encodedValue.append(esc);
            } else {
                encodedValue.append(c);
            }
            ++i;
        }
        return encodedValue.toString();
    }

    public static String nameDecode(String value) throws BadLdapGrammarException {
        if (value == null) {
            return null;
        }
        StringBuffer decoded = new StringBuffer(value.length());
        Matcher matcher = VALUE_DECODE_PATTERN.matcher(value);
        int end = 0;
        while (matcher.find()) {
            end = matcher.end();
            if (matcher.group(1) != null) {
                try {
                    char c = (char)Integer.parseInt(matcher.group(1), 16);
                    decoded.append(c);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new BadLdapGrammarException("Escaped hex value Could not be parsed. Found '\\" + matcher.group(1) + "'");
                }
            }
            if (matcher.group(2) != null) {
                decoded.append(matcher.group(2));
                continue;
            }
            if (matcher.group(3) == null) continue;
            decoded.append(matcher.group(3));
        }
        if (end < value.length()) {
            throw new BadLdapGrammarException("RDN could not be parsed fully, remaining '" + StringUtils.substring(value, end) + "'");
        }
        return decoded.toString();
    }
}

