/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework.autoproxy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.adapter.AdvisorAdapterRegistry;
import org.springframework.aop.framework.adapter.GlobalAdvisorAdapterRegistry;
import org.springframework.aop.framework.autoproxy.TargetSourceCreator;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.util.ClassUtils;

public abstract class AbstractAutoProxyCreator
extends ProxyConfig
implements InstantiationAwareBeanPostProcessor,
BeanFactoryAware,
Ordered {
    protected static final Object[] DO_NOT_PROXY = null;
    protected static final Object[] PROXY_WITHOUT_ADDITIONAL_INTERCEPTORS = new Object[0];
    private int order = Integer.MAX_VALUE;
    private AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
    private boolean freezeProxy;
    private String[] interceptorNames = new String[0];
    private boolean applyCommonInterceptorsFirst = true;
    private TargetSourceCreator[] customTargetSourceCreators;
    private BeanFactory beanFactory;
    static /* synthetic */ Class class$org$springframework$aop$Advisor;
    static /* synthetic */ Class class$org$aopalliance$intercept$MethodInterceptor;
    static /* synthetic */ Class class$org$springframework$aop$framework$autoproxy$AbstractAutoProxyCreator;

    public final void setOrder(int order) {
        this.order = order;
    }

    public final int getOrder() {
        return this.order;
    }

    public boolean isFrozen() {
        return this.freezeProxy;
    }

    public void setFrozen(boolean frozen) {
        this.freezeProxy = frozen;
    }

    public void setAdvisorAdapterRegistry(AdvisorAdapterRegistry advisorAdapterRegistry) {
        this.advisorAdapterRegistry = advisorAdapterRegistry;
    }

    public void setCustomTargetSourceCreators(TargetSourceCreator[] targetSourceCreators) {
        this.customTargetSourceCreators = targetSourceCreators;
    }

    public void setInterceptorNames(String[] interceptorNames) {
        this.interceptorNames = interceptorNames;
    }

    public void setApplyCommonInterceptorsFirst(boolean applyCommonInterceptorsFirst) {
        this.applyCommonInterceptorsFirst = applyCommonInterceptorsFirst;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public Object postProcessBeforeInstantiation(Class beanClass, String beanName) throws BeansException {
        if (this.isInfrastructureClass(beanClass, beanName)) {
            return null;
        }
        TargetSource targetSource = this.getCustomTargetSource(beanClass, beanName);
        if (targetSource != null) {
            Object[] specificInterceptors = this.getAdvicesAndAdvisorsForBean(beanClass, beanName, targetSource);
            return this.createProxy(beanClass, beanName, specificInterceptors, targetSource);
        }
        return null;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.isInfrastructureClass(bean.getClass(), beanName)) {
            return bean;
        }
        Object[] specificInterceptors = this.getAdvicesAndAdvisorsForBean(bean.getClass(), beanName, null);
        if (specificInterceptors != DO_NOT_PROXY) {
            return this.createProxy(bean.getClass(), beanName, specificInterceptors, new SingletonTargetSource(bean));
        }
        return bean;
    }

    protected boolean isInfrastructureClass(Class beanClass, String beanName) {
        boolean retVal;
        boolean bl = (class$org$springframework$aop$Advisor == null ? (class$org$springframework$aop$Advisor = AbstractAutoProxyCreator.class$("org.springframework.aop.Advisor")) : class$org$springframework$aop$Advisor).isAssignableFrom(beanClass) || (class$org$aopalliance$intercept$MethodInterceptor == null ? (class$org$aopalliance$intercept$MethodInterceptor = AbstractAutoProxyCreator.class$("org.aopalliance.intercept.MethodInterceptor")) : class$org$aopalliance$intercept$MethodInterceptor).isAssignableFrom(beanClass) || (class$org$springframework$aop$framework$autoproxy$AbstractAutoProxyCreator == null ? (class$org$springframework$aop$framework$autoproxy$AbstractAutoProxyCreator = AbstractAutoProxyCreator.class$("org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator")) : class$org$springframework$aop$framework$autoproxy$AbstractAutoProxyCreator).isAssignableFrom(beanClass) || this.shouldSkip(beanClass, beanName) ? true : (retVal = false);
        if (retVal && this.logger.isDebugEnabled()) {
            this.logger.debug("Did not attempt to autoproxy infrastructure class [" + beanClass.getName() + "]");
        }
        return retVal;
    }

    protected boolean shouldSkip(Class beanClass, String beanName) {
        return false;
    }

    protected TargetSource getCustomTargetSource(Class beanClass, String beanName) {
        if (this.beanFactory != null && this.beanFactory.containsBean(beanName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Checking for custom TargetSource for bean with name '" + beanName + "'");
            }
            if (this.customTargetSourceCreators != null) {
                for (int i = 0; i < this.customTargetSourceCreators.length; ++i) {
                    TargetSourceCreator tsc = this.customTargetSourceCreators[i];
                    TargetSource ts = tsc.getTargetSource(beanClass, beanName);
                    if (ts == null) continue;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("TargetSourceCreator [" + tsc + " found custom TargetSource for bean with name '" + beanName + "'");
                    }
                    return ts;
                }
            }
        }
        return null;
    }

    protected Object createProxy(Class beanClass, String beanName, Object[] specificInterceptors, TargetSource targetSource) {
        Advisor[] commonInterceptors = this.resolveInterceptorNames();
        ArrayList<Object> allInterceptors = new ArrayList<Object>();
        if (specificInterceptors != null) {
            allInterceptors.addAll(Arrays.asList(specificInterceptors));
            if (commonInterceptors != null) {
                if (this.applyCommonInterceptorsFirst) {
                    allInterceptors.addAll(0, Arrays.asList(commonInterceptors));
                } else {
                    allInterceptors.addAll(Arrays.asList(commonInterceptors));
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            int nrOfCommonInterceptors = commonInterceptors != null ? commonInterceptors.length : 0;
            int nrOfSpecificInterceptors = specificInterceptors != null ? specificInterceptors.length : 0;
            this.logger.debug("Creating implicit proxy for bean '" + beanName + "' with " + nrOfCommonInterceptors + " common interceptors and " + nrOfSpecificInterceptors + " specific interceptors");
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.copyFrom(this);
        if (!this.isProxyTargetClass()) {
            Class[] targetsInterfaces = ClassUtils.getAllInterfacesForClass(beanClass);
            for (int i = 0; i < targetsInterfaces.length; ++i) {
                proxyFactory.addInterface(targetsInterfaces[i]);
            }
        }
        Iterator it = allInterceptors.iterator();
        while (it.hasNext()) {
            Advisor advisor = this.advisorAdapterRegistry.wrap(it.next());
            proxyFactory.addAdvisor(advisor);
        }
        proxyFactory.setTargetSource(targetSource);
        this.customizeProxyFactory(proxyFactory);
        proxyFactory.setFrozen(this.freezeProxy);
        return proxyFactory.getProxy();
    }

    private Advisor[] resolveInterceptorNames() {
        Advisor[] advisors = new Advisor[this.interceptorNames.length];
        for (int i = 0; i < this.interceptorNames.length; ++i) {
            Object next = this.beanFactory.getBean(this.interceptorNames[i]);
            advisors[i] = this.advisorAdapterRegistry.wrap(next);
        }
        return advisors;
    }

    protected void customizeProxyFactory(ProxyFactory proxyFactory) {
    }

    protected abstract Object[] getAdvicesAndAdvisorsForBean(Class var1, String var2, TargetSource var3) throws BeansException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

