/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework.autoproxy.target;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.autoproxy.TargetSourceCreator;
import org.springframework.aop.target.AbstractBeanFactoryBasedTargetSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;

public abstract class AbstractBeanFactoryBasedTargetSourceCreator
implements TargetSourceCreator,
BeanFactoryAware,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private AbstractBeanFactory beanFactory;
    private DefaultListableBeanFactory internalBeanFactory;

    public final void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof AbstractBeanFactory)) {
            throw new IllegalArgumentException("Cannot do auto-TargetSource creation with a BeanFactory that doesn't extend AbstractBeanFactory: " + beanFactory);
        }
        this.beanFactory = (AbstractBeanFactory)beanFactory;
        this.internalBeanFactory = new DefaultListableBeanFactory(beanFactory);
    }

    protected final BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public final TargetSource getTargetSource(Class beanClass, String beanName) {
        AbstractBeanFactoryBasedTargetSource targetSource = this.createBeanFactoryBasedTargetSource(beanClass, beanName);
        if (targetSource == null) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Configuring AbstractBeanFactoryBasedTargetSource: " + targetSource);
        }
        RootBeanDefinition bd = this.beanFactory.getMergedBeanDefinition(beanName);
        RootBeanDefinition bdCopy = new RootBeanDefinition(bd);
        bdCopy.setSingleton(!this.isPrototypeBased());
        this.internalBeanFactory.registerBeanDefinition(beanName, bdCopy);
        targetSource.setTargetBeanName(beanName);
        targetSource.setBeanFactory(this.internalBeanFactory);
        return targetSource;
    }

    protected boolean isPrototypeBased() {
        return true;
    }

    protected abstract AbstractBeanFactoryBasedTargetSource createBeanFactoryBasedTargetSource(Class var1, String var2);

    public void destroy() {
        this.internalBeanFactory.destroySingletons();
    }
}

