/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class BeansDtdResolver
implements EntityResolver {
    private static final String DTD_NAME = "spring-beans";
    protected final Log logger = LogFactory.getLog(this.getClass());

    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        block6: {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Trying to resolve XML entity with public ID [" + publicId + "] and system ID [" + systemId + "]");
            }
            if (systemId != null && systemId.indexOf(DTD_NAME) > systemId.lastIndexOf("/")) {
                String dtdFile = systemId.substring(systemId.indexOf(DTD_NAME));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Trying to locate [" + dtdFile + "] in Spring jar");
                }
                try {
                    ClassPathResource resource = new ClassPathResource(dtdFile, this.getClass());
                    InputSource source = new InputSource(resource.getInputStream());
                    source.setPublicId(publicId);
                    source.setSystemId(systemId);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Found beans DTD [" + systemId + "] in classpath");
                    }
                    return source;
                }
                catch (IOException ex) {
                    if (!this.logger.isDebugEnabled()) break block6;
                    this.logger.debug("Could not resolve beans DTD [" + systemId + "]: not found in class path", ex);
                }
            }
        }
        return null;
    }
}

