/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.access;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.SingletonBeanFactoryLocator;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.support.ResourcePatternUtils;

public class ContextSingletonBeanFactoryLocator
extends SingletonBeanFactoryLocator {
    private static final String BEANS_REFS_XML_NAME = "classpath*:beanRefContext.xml";
    private static final Map instances = new HashMap();

    public static BeanFactoryLocator getInstance() throws BeansException {
        return ContextSingletonBeanFactoryLocator.getInstance(BEANS_REFS_XML_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanFactoryLocator getInstance(String selector) throws BeansException {
        if (!ResourcePatternUtils.isUrl(selector)) {
            selector = "classpath*:" + selector;
        }
        Map map = instances;
        synchronized (map) {
            BeanFactoryLocator bfl;
            if (logger.isDebugEnabled()) {
                logger.debug("ContextSingletonBeanFactoryLocator.getInstance(): instances.hashCode=" + ((Object)instances).hashCode() + ", instances=" + instances);
            }
            if ((bfl = (BeanFactoryLocator)instances.get(selector)) == null) {
                bfl = new ContextSingletonBeanFactoryLocator(selector);
                instances.put(selector, bfl);
            }
            return bfl;
        }
    }

    protected ContextSingletonBeanFactoryLocator() {
        super(BEANS_REFS_XML_NAME);
    }

    protected ContextSingletonBeanFactoryLocator(String resourceName) {
        super(resourceName);
    }

    protected BeanFactory createDefinition(String resourceName, String factoryKey) throws BeansException {
        return new ClassPathXmlApplicationContext(new String[]{resourceName}, false);
    }

    protected void initializeDefinition(BeanFactory groupDef) throws BeansException {
        if (groupDef instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)groupDef).refresh();
        }
    }

    protected void destroyDefinition(BeanFactory groupDef, String resourceName) throws BeansException {
        if (groupDef instanceof ConfigurableApplicationContext) {
            if (logger.isDebugEnabled()) {
                logger.debug("ContextSingletonBeanFactoryLocator group with resourceName '" + resourceName + "' being released, as there are no more references");
            }
            ((ConfigurableApplicationContext)groupDef).close();
        }
    }
}

