/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.IOException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.support.AbstractApplicationContext;

public abstract class AbstractRefreshableApplicationContext
extends AbstractApplicationContext {
    private DefaultListableBeanFactory beanFactory;

    public AbstractRefreshableApplicationContext() {
    }

    public AbstractRefreshableApplicationContext(ApplicationContext parent) {
        super(parent);
    }

    protected final void refreshBeanFactory() throws BeansException {
        if (this.beanFactory != null) {
            this.beanFactory.destroySingletons();
            this.beanFactory = null;
        }
        try {
            DefaultListableBeanFactory beanFactory = this.createBeanFactory();
            this.loadBeanDefinitions(beanFactory);
            this.beanFactory = beanFactory;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Bean factory for application context [" + this.getDisplayName() + "]: " + beanFactory);
            }
        }
        catch (IOException ex) {
            throw new ApplicationContextException("I/O error parsing XML document for application context [" + this.getDisplayName() + "]", ex);
        }
    }

    public final ConfigurableListableBeanFactory getBeanFactory() {
        if (this.beanFactory == null) {
            throw new IllegalStateException("BeanFactory not initialized - call 'refresh' before accessing beans via the context: " + this);
        }
        return this.beanFactory;
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        return new DefaultListableBeanFactory(this.getInternalParentBeanFactory());
    }

    protected abstract void loadBeanDefinitions(DefaultListableBeanFactory var1) throws IOException, BeansException;
}

