/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jndi;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jndi.JndiCallback;

public class JndiTemplate {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Properties environment;

    public JndiTemplate() {
    }

    public JndiTemplate(Properties environment) {
        this.environment = environment;
    }

    public void setEnvironment(Properties environment) {
        this.environment = environment;
    }

    public Properties getEnvironment() {
        return this.environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(JndiCallback contextCallback) throws NamingException {
        Context ctx = this.createInitialContext();
        try {
            Object object = contextCallback.doInContext(ctx);
            return object;
        }
        finally {
            try {
                ctx.close();
            }
            catch (NamingException ex) {
                this.logger.warn("Could not close JNDI InitialContext", ex);
            }
        }
    }

    protected Context createInitialContext() throws NamingException {
        return new InitialContext(this.getEnvironment());
    }

    public Object lookup(final String name) throws NamingException {
        if (this.logger.isInfoEnabled()) {
            this.logger.debug("Looking up JNDI object with name [" + name + "]");
        }
        return this.execute(new JndiCallback(){

            public Object doInContext(Context ctx) throws NamingException {
                Object located = ctx.lookup(name);
                if (located == null) {
                    throw new NamingException("JNDI object with [" + name + "] not found: JNDI implementation returned null");
                }
                return located;
            }
        });
    }

    public Object lookup(String name, Class requiredType) throws NamingException {
        Object jndiObject = this.lookup(name);
        if (requiredType != null && !requiredType.isInstance(jndiObject)) {
            throw new NamingException("Object [" + jndiObject + "] available at JNDI location [" + name + "] is not assignable to [" + requiredType.getName() + "]");
        }
        return jndiObject;
    }

    public void bind(final String name, final Object object) throws NamingException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Binding JNDI object with name [" + name + "]");
        }
        this.execute(new JndiCallback(){

            public Object doInContext(Context ctx) throws NamingException {
                ctx.bind(name, object);
                return null;
            }
        });
    }

    public void rebind(final String name, final Object object) throws NamingException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Rebinding JNDI object with name [" + name + "]");
        }
        this.execute(new JndiCallback(){

            public Object doInContext(Context ctx) throws NamingException {
                ctx.rebind(name, object);
                return null;
            }
        });
    }

    public void unbind(final String name) throws NamingException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Unbinding JNDI object with name [" + name + "]");
        }
        this.execute(new JndiCallback(){

            public Object doInContext(Context ctx) throws NamingException {
                ctx.unbind(name);
                return null;
            }
        });
    }
}

