/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui.context.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.ui.context.HierarchicalThemeSource;
import org.springframework.ui.context.ThemeSource;
import org.springframework.ui.context.support.DelegatingThemeSource;
import org.springframework.ui.context.support.ResourceBundleThemeSource;

public abstract class UiApplicationContextUtils {
    public static final String THEME_SOURCE_BEAN_NAME = "themeSource";
    private static final Log logger = LogFactory.getLog(class$org$springframework$ui$context$support$UiApplicationContextUtils == null ? (class$org$springframework$ui$context$support$UiApplicationContextUtils = UiApplicationContextUtils.class$("org.springframework.ui.context.support.UiApplicationContextUtils")) : class$org$springframework$ui$context$support$UiApplicationContextUtils);
    static /* synthetic */ Class class$org$springframework$ui$context$support$UiApplicationContextUtils;
    static /* synthetic */ Class class$org$springframework$ui$context$ThemeSource;

    public static ThemeSource initThemeSource(ApplicationContext context) {
        if (context.containsLocalBean(THEME_SOURCE_BEAN_NAME)) {
            HierarchicalThemeSource hts;
            ThemeSource themeSource = (ThemeSource)context.getBean(THEME_SOURCE_BEAN_NAME, class$org$springframework$ui$context$ThemeSource == null ? (class$org$springframework$ui$context$ThemeSource = UiApplicationContextUtils.class$("org.springframework.ui.context.ThemeSource")) : class$org$springframework$ui$context$ThemeSource);
            if (context.getParent() instanceof ThemeSource && themeSource instanceof HierarchicalThemeSource && (hts = (HierarchicalThemeSource)themeSource).getParentThemeSource() == null) {
                hts.setParentThemeSource((ThemeSource)((Object)context.getParent()));
            }
            if (logger.isInfoEnabled()) {
                logger.info("Using ThemeSource [" + themeSource + "]");
            }
            return themeSource;
        }
        HierarchicalThemeSource themeSource = null;
        if (context.getParent() instanceof ThemeSource) {
            themeSource = new DelegatingThemeSource();
            themeSource.setParentThemeSource((ThemeSource)((Object)context.getParent()));
        } else {
            themeSource = new ResourceBundleThemeSource();
        }
        if (logger.isInfoEnabled()) {
            logger.info("Unable to locate ThemeSource with name 'themeSource': using default [" + themeSource + "]");
        }
        return themeSource;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

