/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.pkgscanner;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.twdata.pkgscanner.DefaultOsgiVersionConverter;
import org.twdata.pkgscanner.ExportPackage;
import org.twdata.pkgscanner.OsgiVersionConverter;
import org.twdata.pkgscanner.PackageScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InternalScanner {
    private ClassLoader classloader;
    private PackageScanner.VersionMapping[] versionMappings;
    private OsgiVersionConverter versionConverter = new DefaultOsgiVersionConverter();

    InternalScanner(ClassLoader cl, PackageScanner.VersionMapping[] versionMappings) {
        this.classloader = cl;
        this.versionMappings = versionMappings;
    }

    void setOsgiVersionConverter(OsgiVersionConverter converter) {
        this.versionConverter = converter;
    }

    Collection<ExportPackage> findInPackages(Test test, String ... roots) {
        HashMap<String, ExportPackage> map = new HashMap<String, ExportPackage>();
        for (String pkg : roots) {
            for (ExportPackage export : this.findInPackage(test, pkg)) {
                map.put(export.getPackageName(), export);
            }
        }
        return new TreeSet<ExportPackage>(map.values());
    }

    Collection<ExportPackage> findInUrls(Test test, URL ... urls) {
        HashMap<String, ExportPackage> map = new HashMap<String, ExportPackage>();
        Vector<URL> list = new Vector<URL>(Arrays.asList(urls));
        for (ExportPackage export : this.findInPackageWithUrls(test, "", list.elements())) {
            map.put(export.getPackageName(), export);
        }
        return new TreeSet<ExportPackage>(map.values());
    }

    List<ExportPackage> findInPackage(Test test, String packageName) {
        Enumeration<URL> urls;
        ArrayList<ExportPackage> localExports = new ArrayList<ExportPackage>();
        packageName = packageName.replace('.', '/');
        try {
            urls = this.classloader.getResources(packageName);
        }
        catch (IOException ioe) {
            System.err.println("Could not read package: " + packageName);
            return localExports;
        }
        return this.findInPackageWithUrls(test, packageName, urls);
    }

    List<ExportPackage> findInPackageWithUrls(Test test, String packageName, Enumeration<URL> urls) {
        ArrayList<ExportPackage> localExports = new ArrayList<ExportPackage>();
        while (urls.hasMoreElements()) {
            try {
                File file;
                String urlPath = urls.nextElement().getPath();
                urlPath = URLDecoder.decode(urlPath, "UTF-8");
                if (urlPath.startsWith("file:")) {
                    urlPath = urlPath.substring(5);
                }
                if (urlPath.lastIndexOf(33) > 0) {
                    urlPath = urlPath.substring(0, urlPath.lastIndexOf(33));
                }
                if ((file = new File(urlPath)).isDirectory()) {
                    localExports.addAll(this.loadImplementationsInDirectory(test, packageName, file));
                    continue;
                }
                if (!test.matchesJar(file.getName())) continue;
                localExports.addAll(this.loadImplementationsInJar(test, packageName, file));
            }
            catch (IOException ioe) {
                System.err.println("could not read entries: " + ioe);
            }
        }
        return localExports;
    }

    List<ExportPackage> loadImplementationsInDirectory(Test test, String parent, File location) {
        File[] files = location.listFiles();
        StringBuilder builder = null;
        ArrayList<ExportPackage> localExports = new ArrayList<ExportPackage>();
        HashSet<String> scanned = new HashSet<String>();
        for (File file : files) {
            String packageOrClass;
            builder = new StringBuilder(100);
            builder.append(parent).append("/").append(file.getName());
            String string = packageOrClass = parent == null ? file.getName() : builder.toString();
            if (file.isDirectory()) {
                localExports.addAll(this.loadImplementationsInDirectory(test, packageOrClass, file));
                continue;
            }
            if ("".equals(parent) && file.getName().endsWith(".jar") && test.matchesJar(file.getName())) {
                localExports.addAll(this.loadImplementationsInJar(test, "", file));
                continue;
            }
            String pkg = packageOrClass;
            int lastSlash = pkg.lastIndexOf(47);
            if (lastSlash > 0) {
                pkg = pkg.substring(0, lastSlash);
            }
            if (scanned.contains(pkg = pkg.replace("/", "."))) continue;
            if (test.matchesPackage(pkg)) {
                localExports.add(new ExportPackage(pkg, this.determinePackageVersion(null, pkg)));
            }
            scanned.add(pkg);
        }
        return localExports;
    }

    List<ExportPackage> loadImplementationsInJar(Test test, String parent, File file) {
        ArrayList<ExportPackage> localExports = new ArrayList<ExportPackage>();
        try {
            JarFile jarFile;
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException ex) {
                jarFile = new JarFile(new File(file.getAbsolutePath().replace(" ", "+")));
            }
            HashSet<String> scanned = new HashSet<String>();
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || !name.startsWith(parent)) continue;
                String pkg = name;
                int pos = pkg.lastIndexOf(47);
                if (pos > -1) {
                    pkg = pkg.substring(0, pos);
                }
                if (scanned.contains(pkg = pkg.replace("/", "."))) continue;
                if (test.matchesPackage(pkg)) {
                    localExports.add(new ExportPackage(pkg, this.determinePackageVersion(file, pkg)));
                }
                scanned.add(pkg);
            }
        }
        catch (IOException ioe) {
            System.err.println("Could not search jar file '" + file + "' for classes matching criteria: " + test + " due to an IOException" + ioe);
        }
        return localExports;
    }

    String determinePackageVersion(File jar, String pkg) {
        String version = null;
        for (PackageScanner.VersionMapping mapping : this.versionMappings) {
            if (!mapping.matches(pkg)) continue;
            version = mapping.getVersion();
        }
        if (version == null && jar != null && version == null) {
            String name = jar.getName();
            return this.extractVersion(name);
        }
        return version;
    }

    String extractVersion(String filename) {
        StringBuilder version = null;
        boolean lastWasSeparator = false;
        for (int x = 0; x < filename.length(); ++x) {
            char c = filename.charAt(x);
            if (c == '-' || c == '_') {
                lastWasSeparator = true;
            } else if (Character.isDigit(c) && lastWasSeparator && version == null) {
                version = new StringBuilder();
            }
            if (version == null) continue;
            version.append(c);
        }
        if (version != null) {
            if (".jar".equals(version.substring(version.length() - 4))) {
                version.delete(version.length() - 4, version.length());
            }
            return this.versionConverter.getVersion(version.toString());
        }
        return null;
    }

    static interface Test {
        public boolean matchesPackage(String var1);

        public boolean matchesJar(String var1);
    }
}

