/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.api;

import com.yourkit.api.PeriodicalDumperStatus;
import com.yourkit.api.ProgressListener;
import com.yourkit.api.TelemetryProtocolImpl1;
import com.yourkit.api.TelemetryProtocolImpl2;
import com.yourkit.api.TelemetryRecord2;
import com.yourkit.runtime.AgentProtocolException;
import com.yourkit.runtime.AgentReportedErrorException;
import com.yourkit.runtime.CLRInfo;
import com.yourkit.runtime.CaptureSnapshotRes;
import com.yourkit.runtime.JVMInfo;
import com.yourkit.runtime.Packet;
import com.yourkit.runtime.StackTraceElementRes;
import com.yourkit.runtime.ThreadInfoRes;
import com.yourkit.util.Asserts;
import com.yourkit.util.SnapshotInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;

public final class ControllerImpl {
    private final String myHost;
    private final int myPort;
    private final long myInitialStatus;
    private final int myInitialUsedMemoryThreshold;
    private final int myInitialOOMEDumperStatus;
    private PeriodicalDumperStatus myInitialPeriodicalDumperStatus;
    private String mySessionName;
    private String mySessionID;
    private long myCapabilities;
    private JVMInfo myJVMInfo;
    private CLRInfo myCLRInfo;
    private String myJavaVersion;
    private Boolean myTelemetryProtocol2;

    public ControllerImpl(String host, int port) throws Exception {
        if (host == null) {
            throw new IllegalArgumentException("host cannot be null");
        }
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("port must be in range 1-65535: " + port);
        }
        this.myHost = host;
        this.myPort = port;
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 3000);
                Packet.flush(output);
                Packet.readHeader(input, 3001);
                ControllerImpl.this.mySessionName = Packet.readStringNotNull(input);
            }
        });
        Asserts.notNull(this.mySessionName);
        try {
            this.makeRequest(new Communication(){

                public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                    Packet.writeHeader(output, 34000);
                    Packet.flush(output);
                    Packet.readHeader(input, 34001);
                    ControllerImpl.this.mySessionID = Packet.readString(input);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 19000);
                Packet.flush(output);
                Packet.readHeader(input, 19001);
                ControllerImpl.this.myJavaVersion = Packet.readStringNotNull(input);
            }
        });
        Asserts.notNull(this.myJavaVersion);
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 1000);
                Packet.flush(output);
                Packet.readHeader(input, 1001);
                ControllerImpl.this.myCapabilities = Packet.readLong(input);
            }
        });
        if ((this.myCapabilities & 0x200L) != 0L) {
            this.makeRequest(new Communication(){

                public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                    Packet.writeHeader(output, 5000);
                    Packet.flush(output);
                    Packet.readHeader(input, 5001);
                    String vmName = Packet.readString(input);
                    String vmVersion = Packet.readString(input);
                    String vmVendor = Packet.readString(input);
                    String inputArguments = Packet.readString(input);
                    String classPath = Packet.readString(input);
                    String libraryPath = Packet.readString(input);
                    String bootClassPath = Packet.readString(input);
                    String osName = Packet.readString(input);
                    String osArch = Packet.readString(input);
                    String osVersion = Packet.readString(input);
                    long startTime = Packet.readLong(input);
                    ControllerImpl.this.myJVMInfo = new JVMInfo(vmName, vmVersion, vmVendor, inputArguments, classPath, libraryPath, bootClassPath, osName, osArch, osVersion, startTime);
                }
            });
        }
        if ((this.myCapabilities & 0x400L) != 0L) {
            this.makeRequest(new Communication(){

                public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                    Packet.writeHeader(output, 5500);
                    Packet.flush(output);
                    Packet.readHeader(input, 5501);
                    String clrVersion = Packet.readString(input);
                    String commandLine = Packet.readString(input);
                    String osName = Packet.readString(input);
                    String osArch = Packet.readString(input);
                    String osVersion = Packet.readString(input);
                    long startTime = Packet.readLong(input);
                    ControllerImpl.this.myCLRInfo = new CLRInfo(clrVersion, commandLine, osName, osArch, osVersion, startTime);
                }
            });
        }
        this.myInitialStatus = this.getStatus();
        this.myInitialUsedMemoryThreshold = (this.myCapabilities & 0x80L) != 0L ? this.getUsedMemoryThreshold() : 0;
        this.myInitialOOMEDumperStatus = this.getOOMEDumperStatus();
        this.myInitialPeriodicalDumperStatus = this.getPeriodicalDumperStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeRequest(Communication communication) throws Exception {
        try {
            Socket socket = new Socket(this.myHost, this.myPort);
            try {
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
                try {
                    DataInputStream input = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
                    try {
                        communication.perform(input, out);
                    }
                    finally {
                        input.close();
                    }
                }
                finally {
                    out.close();
                }
            }
            finally {
                socket.close();
            }
        }
        catch (Throwable exc) {
            throw this.transformException(exc);
        }
    }

    private Exception transformException(Throwable exc) {
        String message;
        if (exc instanceof UnknownHostException) {
            return new Exception("Cannot connect to host " + this.myHost);
        }
        if (exc instanceof AgentProtocolException) {
            return new Exception("Communication with the profiler agent failed.\nPossible reason: the agent is incompatible with the current version of the profiler.", exc);
        }
        if (exc instanceof AgentReportedErrorException) {
            return (Exception)exc;
        }
        if (exc instanceof IOException && (message = exc.getMessage()) != null && (message.startsWith("Connection refused") || message.startsWith("Connection reset"))) {
            return new Exception("There's no application running at " + this.myHost + " with profiler agent configured to listen on port " + this.myPort, exc);
        }
        return new Exception("There's no application running at " + this.myHost + " with profiler agent configured to listen on port " + this.myPort + "\nor profiler agent is incompatible with current version of profiler", exc);
    }

    public final String getHost() {
        return this.myHost;
    }

    public final int getPort() {
        return this.myPort;
    }

    public final long getStatus() throws Exception {
        final long[] result = new long[1];
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 2000);
                Packet.flush(output);
                Packet.readHeader(input, 2001);
                result[0] = Packet.readLong(input);
            }
        });
        return result[0];
    }

    public final String getSessionID() {
        return this.mySessionID;
    }

    public final String getSessionName() {
        return this.mySessionName;
    }

    public final JVMInfo getJVMInfo() {
        if ((this.myCapabilities & 0x200L) == 0L) {
            throw new UnsupportedOperationException();
        }
        return this.myJVMInfo;
    }

    public final CLRInfo getCLRInfo() {
        if ((this.myCapabilities & 0x400L) == 0L) {
            throw new UnsupportedOperationException();
        }
        return this.myCLRInfo;
    }

    public final void startCPUProfiling(final long mode, final String filters) throws Exception {
        if ((mode & 4L) == 0L || (mode & 0xFFFFFFFFFFFFFFD3L) != 0L) {
            throw new IllegalArgumentException("bad mode: " + mode);
        }
        try {
            this.makeRequest(new Communication(){

                public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                    Packet.writeHeader(output, 50000);
                    Packet.writeLong(output, mode);
                    Packet.writeString(output, filters);
                    Packet.flush(output);
                    Packet.readHeader(input, 50001);
                }
            });
        }
        catch (AgentReportedErrorException e) {
            if (!e.isUnknownPacketError()) {
                throw e;
            }
            this.makeRequest(new Communication(){

                public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                    long _mode = mode & 0xFFFFFFFFFFFFFFDFL;
                    if (_mode == 4L) {
                        Packet.writeHeader(output, 8000);
                        Packet.flush(output);
                        Packet.readHeader(input, 8001);
                    } else if (_mode == 12L) {
                        Packet.writeHeader(output, 9000);
                        Packet.flush(output);
                        Packet.readHeader(input, 9001);
                    } else {
                        throw new AgentProtocolException("unexpected mode " + mode);
                    }
                }
            });
        }
    }

    public void stopCPUProfiling() throws Exception {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 10000);
                Packet.flush(output);
                Packet.readHeader(input, 10001);
            }
        });
    }

    public void startAllocationRecording(final long mode) throws Exception {
        if ((mode & 2L) == 0L || (mode & 0xFFFFFFFFFFFFFFBDL) != 0L) {
            throw new IllegalArgumentException("bad mode: " + mode);
        }
        try {
            this.makeRequest(new Communication(){

                public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                    Packet.writeHeader(output, 39000);
                    Packet.writeLong(output, mode);
                    Packet.flush(output);
                    Packet.readHeader(input, 39001);
                }
            });
        }
        catch (AgentReportedErrorException e) {
            if (!e.isUnknownPacketError()) {
                throw e;
            }
            this.makeRequest(new Communication(){

                public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                    Packet.writeHeader(output, 6000);
                    Packet.flush(output);
                    Packet.readHeader(input, 6001);
                }
            });
        }
    }

    public void stopAllocationRecording() throws Exception {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 7000);
                Packet.flush(output);
                Packet.readHeader(input, 7001);
            }
        });
    }

    public final long[] forceGC() throws Exception {
        final long[] result = new long[2];
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 11000);
                Packet.flush(output);
                Packet.readHeader(input, 11001);
                result[0] = Packet.readLong(input);
                result[1] = Packet.readLong(input);
            }
        });
        return result;
    }

    public final long getInitialStatus() {
        return this.myInitialStatus;
    }

    public int getInitialUsedMemoryThreshold() {
        return this.myInitialUsedMemoryThreshold;
    }

    public final int getInitialOOMEDumperStatus() {
        return this.myInitialOOMEDumperStatus;
    }

    public PeriodicalDumperStatus getInitialPeriodicalDumperStatus() {
        return this.myInitialPeriodicalDumperStatus;
    }

    public long getCapabilities() {
        return this.myCapabilities;
    }

    public TelemetryRecord2[] getTelemetryRecords(final long timestampMs) throws Exception {
        final ArrayList result = new ArrayList();
        if (this.myTelemetryProtocol2 != null) {
            this.makeRequest(new Communication(){

                public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                    if (ControllerImpl.this.myTelemetryProtocol2.booleanValue()) {
                        TelemetryProtocolImpl2.getTelemetryRecordsImpl(input, output, timestampMs, result);
                    } else {
                        TelemetryProtocolImpl1.getTelemetryRecordsImpl(input, output, timestampMs, result);
                    }
                }
            });
        } else {
            try {
                this.makeRequest(new Communication(){

                    public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                        TelemetryProtocolImpl2.getTelemetryRecordsImpl(input, output, timestampMs, result);
                        ControllerImpl.this.myTelemetryProtocol2 = Boolean.TRUE;
                    }
                });
            }
            catch (Exception e) {
                this.myTelemetryProtocol2 = Boolean.FALSE;
                this.makeRequest(new Communication(){

                    public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                        TelemetryProtocolImpl1.getTelemetryRecordsImpl(input, output, timestampMs, result);
                    }
                });
            }
        }
        return result.toArray(new TelemetryRecord2[result.size()]);
    }

    private static CaptureSnapshotRes readProgressAndSnapshotRes(DataInputStream input, ProgressListener listener, int progressPacketType, int snapshotRespPacketType) throws IOException {
        int packetType;
        while ((packetType = Packet.readHeader(input)) == progressPacketType) {
            int percents = Packet.readInt(input);
            if (percents < 0 || percents > 99) {
                throw new AgentProtocolException("Wrong percents: " + percents);
            }
            if (listener == null) continue;
            listener.update(percents);
        }
        if (packetType == snapshotRespPacketType) {
            String path = Packet.readStringNotNull(input);
            long transferID = Packet.readLong(input);
            return new CaptureSnapshotRes(path, transferID);
        }
        throw new AgentProtocolException("Unexpected packet type: " + packetType);
    }

    public final CaptureSnapshotRes captureMemorySnapshot(final boolean continueAllocationRecording, final ProgressListener listener) throws Exception {
        final CaptureSnapshotRes[] result = new CaptureSnapshotRes[1];
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 13000);
                Packet.writeInt(output, continueAllocationRecording ? 1 : 0);
                Packet.flush(output);
                result[0] = ControllerImpl.readProgressAndSnapshotRes(input, listener, 14001, 14002);
            }
        });
        return result[0];
    }

    public final CaptureSnapshotRes captureCPUSnapshot(final boolean continueCPUProfiling, final ProgressListener listener) throws Exception {
        final CaptureSnapshotRes[] result = new CaptureSnapshotRes[1];
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 12000);
                Packet.writeInt(output, continueCPUProfiling ? 1 : 0);
                Packet.flush(output);
                result[0] = ControllerImpl.readProgressAndSnapshotRes(input, listener, 12001, 12002);
            }
        });
        return result[0];
    }

    public final CaptureSnapshotRes captureTelemetrySnapshot(final ProgressListener listener) throws Exception {
        final CaptureSnapshotRes[] result = new CaptureSnapshotRes[1];
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 37000);
                Packet.flush(output);
                result[0] = ControllerImpl.readProgressAndSnapshotRes(input, listener, 37001, 37002);
            }
        });
        return result[0];
    }

    public final void transferSnapshot(final long transferID, final ChunkProcessor processor) throws Exception {
        Asserts.notNull(processor);
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                int read;
                Packet.writeHeader(output, 15000);
                Packet.writeLong(output, transferID);
                Packet.flush(output);
                byte[] buffer = new byte[65536];
                Packet.readHeader(input, 15001);
                long fileLength = Packet.readLong(input);
                if (fileLength <= 0L) {
                    throw new AgentProtocolException("Wrong fileLength: " + fileLength);
                }
                long transferred = 0L;
                while ((read = Packet.readBytes(input, buffer)) != -1) {
                    if (transferred + (long)read > fileLength) {
                        throw new AgentProtocolException("Too long stream");
                    }
                    processor.processNextChunk(fileLength, buffer, read);
                    if ((transferred += (long)read) != fileLength) continue;
                    break;
                }
            }
        });
    }

    public int getUsedMemoryThreshold() throws Exception {
        final int[] result = new int[1];
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 17000);
                Packet.flush(output);
                Packet.readHeader(input, 17001);
                result[0] = Packet.readInt(input);
            }
        });
        return result[0];
    }

    public void setUsedMemoryThreshold(final int value) throws Exception {
        if (value < 0 || value > 99) {
            throw new IllegalArgumentException("" + value);
        }
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 18000);
                Packet.writeInt(output, value);
                Packet.flush(output);
                Packet.readHeader(input, 18001);
            }
        });
    }

    public PeriodicalDumperStatus getPeriodicalDumperStatus() throws Exception {
        final PeriodicalDumperStatus[] result = new PeriodicalDumperStatus[1];
        try {
            this.makeRequest(new Communication(){

                public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                    Packet.writeHeader(output, 44000);
                    Packet.flush(output);
                    Packet.readHeader(input, 44001);
                    long periodSec = Packet.readLong(input);
                    int maxSnapshotCount = Packet.readInt(input);
                    int alreadyCapturedSnapshotCount = Packet.readInt(input);
                    result[0] = new PeriodicalDumperStatus(periodSec, maxSnapshotCount, alreadyCapturedSnapshotCount);
                }
            });
        }
        catch (AgentReportedErrorException e) {
            if (!e.isUnknownPacketError()) {
                throw e;
            }
            return null;
        }
        return result[0];
    }

    public void setupPeriodicalDumper(final long periodSec, final int maxSnapshotCount) throws Exception {
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 45000);
                Packet.writeLong(output, periodSec);
                Packet.writeInt(output, maxSnapshotCount);
                Packet.flush(output);
                Packet.readHeader(input, 45001);
            }
        });
    }

    public ThreadInfoRes[] getJVMThreadDump(final long[] op_timestampMs) throws Exception {
        Asserts.notNull(op_timestampMs);
        Asserts.assertTrue(op_timestampMs.length == 1);
        final ThreadInfoRes[][] wrapper = new ThreadInfoRes[1][];
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 32002);
                Packet.flush(output);
                Packet.readHeader(input, 32003);
                op_timestampMs[0] = Packet.readLong(input);
                int infoCount = Packet.readInt(input);
                ThreadInfoRes[] result = new ThreadInfoRes[infoCount];
                wrapper[0] = result;
                for (int i = infoCount - 1; i >= 0; --i) {
                    long threadID = Packet.readLong(input);
                    String threadName = Packet.readString(input);
                    long blockedTimeMs = Packet.readLong(input);
                    long blockedCount = Packet.readLong(input);
                    long waitedTimeMs = Packet.readLong(input);
                    long waitedCount = Packet.readLong(input);
                    String lockName = Packet.readString(input);
                    long lockOwerID = Packet.readLong(input);
                    boolean inNative = Packet.readInt(input) != 1;
                    boolean suspnded = Packet.readInt(input) != 0;
                    int statusOrdinal = Packet.readInt(input);
                    int stackTraceElementCount = Packet.readInt(input);
                    StackTraceElementRes[] elements = new StackTraceElementRes[stackTraceElementCount];
                    for (int j = 0; j < stackTraceElementCount; ++j) {
                        String declaringClass = Packet.readString(input);
                        String methodName = Packet.readString(input);
                        String fileName = Packet.readString(input);
                        int lineNumber = Packet.readInt(input);
                        elements[j] = new StackTraceElementRes(declaringClass, methodName, fileName, lineNumber);
                    }
                    result[i] = new ThreadInfoRes(threadID, threadName, blockedTimeMs, blockedCount, waitedTimeMs, waitedCount, lockName, lockOwerID, inNative, suspnded, statusOrdinal, elements);
                }
            }
        });
        return wrapper[0];
    }

    public int getOOMEDumperStatus() throws Exception {
        final int[] result = new int[1];
        try {
            this.makeRequest(new Communication(){

                public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                    Packet.writeHeader(output, 46000);
                    Packet.flush(output);
                    Packet.readHeader(input, 46001);
                    result[0] = Packet.readInt(input);
                }
            });
        }
        catch (AgentReportedErrorException e) {
            if (!e.isUnknownPacketError()) {
                throw e;
            }
            return -2;
        }
        return result[0];
    }

    public String getJavaVersion() {
        return this.myJavaVersion;
    }

    public SnapshotInfo[] getCapturedSnapshots(final long laterThanUptimeMs) throws Exception {
        final ArrayList result = new ArrayList();
        this.makeRequest(new Communication(){

            public void perform(DataInputStream input, DataOutputStream output) throws IOException {
                Packet.writeHeader(output, 49000);
                Packet.writeLong(output, laterThanUptimeMs);
                Packet.flush(output);
                Packet.readHeader(input, 49001);
                int count = Packet.readInt(input);
                for (int i = 0; i < count; ++i) {
                    String path = Packet.readStringNotNull(input);
                    long uptimeMs = Packet.readLong(input);
                    boolean isCapturedInBackground = Packet.readInt(input) == 1;
                    result.add(new SnapshotInfo(path, uptimeMs, isCapturedInBackground));
                }
            }
        });
        return result.toArray(new SnapshotInfo[result.size()]);
    }

    public static interface ChunkProcessor {
        public void processNextChunk(long var1, byte[] var3, int var4) throws IOException;
    }

    private static interface Communication {
        public void perform(DataInputStream var1, DataOutputStream var2) throws IOException;
    }
}

