/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.configuration.xml;

import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.DefaultDelegationAccessor;
import com.atlassian.user.configuration.DefaultRepositoryConfiguration;
import com.atlassian.user.configuration.DelegationAccessor;
import com.atlassian.user.configuration.RepositoryProcessor;
import com.atlassian.user.configuration.xml.AtlassianUserXMLParser;
import com.atlassian.user.util.ClassLoaderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class DefaultAtlassianUserXMLParser
implements AtlassianUserXMLParser {
    private static final Logger log = Logger.getLogger((Class)(class$com$atlassian$user$configuration$xml$DefaultAtlassianUserXMLParser == null ? (class$com$atlassian$user$configuration$xml$DefaultAtlassianUserXMLParser = DefaultAtlassianUserXMLParser.class$("com.atlassian.user.configuration.xml.DefaultAtlassianUserXMLParser")) : class$com$atlassian$user$configuration$xml$DefaultAtlassianUserXMLParser));
    private static final String DEFAULT_FILE = "atlassian-user-defaults.xml";
    private static final String CACHE_CONFIG = "cacheConfig";
    private String fileName;
    private Document doc;
    private Node repositoriesNode;
    private Node defaultNode;
    private Node delegationNode;
    private DelegationAccessor delegationAccessor;
    private HashMap defaultComponentClassNamesMap;
    private HashMap defaultComponentDataMap;
    private List repositoryConfigurations;
    public List delegationOrder;
    static /* synthetic */ Class class$com$atlassian$user$configuration$xml$DefaultAtlassianUserXMLParser;

    public DefaultAtlassianUserXMLParser() {
        this.repositoryConfigurations = new ArrayList();
        this.defaultComponentClassNamesMap = new HashMap();
        this.defaultComponentDataMap = new HashMap();
        this.delegationAccessor = new DefaultDelegationAccessor();
        this.delegationOrder = new ArrayList();
    }

    public DefaultAtlassianUserXMLParser(String fileName) throws ConfigurationException {
        this.fileName = fileName;
        this.delegationAccessor = new DefaultDelegationAccessor();
        this.defaultComponentClassNamesMap = new HashMap();
        this.defaultComponentDataMap = new HashMap();
        InputStream is = ClassLoaderUtils.getResourceAsStream(fileName, this.getClass());
        this.parse(is);
    }

    public Node getDefaultNode() throws DocumentException, IOException {
        InputStream defaultIS = ClassLoaderUtils.getResourceAsStream(DEFAULT_FILE, this.getClass());
        SAXReader reader = new SAXReader();
        this.doc = reader.read(defaultIS);
        defaultIS.close();
        this.defaultNode = this.doc.selectSingleNode("//default");
        return this.defaultNode;
    }

    public void parse(InputStream docIS) throws ConfigurationException {
        if (docIS == null) {
            throw new ConfigurationException("Null inputstream: cannot locate atlassian-user.xml");
        }
        SAXReader reader = new SAXReader();
        try {
            this.doc = reader.read(docIS);
        }
        catch (DocumentException e) {
            throw new ConfigurationException(e);
        }
        this.delegationNode = this.doc.selectSingleNode("//delegation");
        this.repositoriesNode = this.doc.selectSingleNode("//repositories");
        if (this.defaultNode == null) {
            try {
                this.getDefaultNode();
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
        }
        this.parseRepositories(this.repositoriesNode);
        if (this.delegationNode != null) {
            this.parseDelegation(this.delegationNode);
        }
    }

    public DelegationAccessor getDelegationAccessor() {
        return this.delegationAccessor;
    }

    protected void parseRepositories(Node repositoriesNode) throws ConfigurationException {
        List repositories = repositoriesNode.selectNodes("*");
        if (repositories.isEmpty()) {
            throw new ConfigurationException("Nothing to init. There are no repositories in [" + this.fileName + "]");
        }
        Iterator repositoriesIterator = repositories.iterator();
        while (repositoriesIterator.hasNext()) {
            Element repositoryElement = (Element)repositoriesIterator.next();
            HashMap componentClassNames = null;
            HashMap components = null;
            HashMap defaultComponentClassNames = (HashMap)this.defaultComponentClassNamesMap.get(repositoryElement.getName());
            HashMap defaultComponents = (HashMap)this.defaultComponentDataMap.get(repositoryElement.getName());
            if (defaultComponentClassNames == null) {
                defaultComponentClassNames = this.prepareDefaultComponentClassNames(repositoryElement);
            }
            if (defaultComponents == null) {
                defaultComponents = this.prepareDefaultComponents(repositoryElement);
            }
            componentClassNames = this.parseRepositoryElementForClassNames(repositoryElement);
            components = this.parseRepositoryElementForStringData(repositoryElement);
            Iterator defaultIter = defaultComponentClassNames.keySet().iterator();
            while (defaultIter.hasNext()) {
                String componentClassName = (String)defaultIter.next();
                if (componentClassNames.containsKey(componentClassName)) continue;
                componentClassNames.put(componentClassName, defaultComponentClassNames.get(componentClassName));
            }
            defaultIter = null;
            defaultIter = defaultComponents.keySet().iterator();
            while (defaultIter.hasNext()) {
                String componentName = (String)defaultIter.next();
                if (components.containsKey(componentName)) continue;
                components.put(componentName, defaultComponents.get(componentName));
            }
            RepositoryProcessor processor = this.instantiateProcessor(componentClassNames);
            String repositoryKey = (String)components.get("key");
            DefaultRepositoryConfiguration configuration = new DefaultRepositoryConfiguration(repositoryKey, processor, components, componentClassNames);
            this.parseForCacheInstruction(configuration);
            this.repositoryConfigurations.add(configuration);
        }
    }

    private void parseForCacheInstruction(DefaultRepositoryConfiguration configuration) {
        String cacheInstruction = (String)configuration.getComponents().get("cache");
        if (cacheInstruction == null || !cacheInstruction.equals("true")) {
            return;
        }
        HashMap cacheComponentClassNames = this.prepareDefaultComponentClassNames("cache");
        HashMap cacheComponents = this.prepareDefaultComponents("cache");
        DefaultRepositoryConfiguration cacheConfig = new DefaultRepositoryConfiguration("cache", null, cacheComponents, cacheComponentClassNames);
        configuration.getComponents().put(CACHE_CONFIG, cacheConfig);
    }

    protected void parseDelegation(Node delegationNode) {
        List repositories = delegationNode.selectNodes("key");
        Iterator repositoriesIterator = repositories.iterator();
        while (repositoriesIterator.hasNext()) {
            Element keyElement = (Element)repositoriesIterator.next();
            String keyText = keyElement.getText();
            this.delegationOrder.add(keyText);
        }
    }

    protected HashMap prepareDefaultComponentClassNames(Element repositoryElement) {
        String repositoryName = repositoryElement.getName();
        HashMap defaultClassNames = this.prepareDefaultComponentClassNames(repositoryName);
        this.defaultComponentClassNamesMap.put(repositoryElement.getName(), defaultClassNames);
        return defaultClassNames;
    }

    protected HashMap prepareDefaultComponentClassNames(String repositoryName) {
        List matchingDefaults = this.defaultNode.selectNodes(repositoryName);
        if (matchingDefaults.isEmpty()) {
            log.fatal((Object)("Cannot find a default processor for [" + repositoryName + "] in atlassian-user-defaults.xml."));
        }
        Element defaultElement = (Element)matchingDefaults.get(0);
        HashMap defaultClassNames = this.parseRepositoryElementForClassNames(defaultElement);
        return defaultClassNames;
    }

    protected HashMap prepareDefaultComponents(Element repositoryElement) {
        String repositoryName = repositoryElement.getName();
        HashMap defaultClassNames = this.prepareDefaultComponents(repositoryName);
        this.defaultComponentDataMap.put(repositoryElement.getName(), defaultClassNames);
        return defaultClassNames;
    }

    protected HashMap prepareDefaultComponents(String repositoryName) {
        List matchingDefaults = this.defaultNode.selectNodes(repositoryName);
        if (matchingDefaults.isEmpty()) {
            log.fatal((Object)("Cannot find a default processor for [" + repositoryName + "] in atlassian-user-defaults.xml. Use the general <repository>...</repository> configuration?"));
        }
        Element defaultElement = (Element)matchingDefaults.get(0);
        HashMap defaultClassNames = this.parseRepositoryElementForStringData(defaultElement);
        return defaultClassNames;
    }

    private RepositoryProcessor instantiateProcessor(HashMap processorInfo) {
        String processorClassName = (String)processorInfo.get("processor");
        RepositoryProcessor processor = null;
        try {
            processor = (RepositoryProcessor)Class.forName(processorClassName).newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Could not instantiate processor: " + e.getMessage()));
        }
        return processor;
    }

    private HashMap parseRepositoryElementForClassNames(Element repositoryElement) {
        HashMap<String, String> values = new HashMap<String, String>();
        Element classesElement = repositoryElement.element("classes");
        if (classesElement == null) {
            return values;
        }
        List subElements = classesElement.elements();
        Iterator iter = subElements.iterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            if (element.getName().equals("param")) {
                Attribute paramAttribute = element.attribute("name");
                values.put(paramAttribute.getText(), element.getText());
                continue;
            }
            values.put(element.getName(), element.getText());
        }
        Attribute attr = repositoryElement.attribute("class");
        if (attr != null) {
            values.put("class", attr.getText());
        }
        return values;
    }

    private HashMap parseRepositoryElementForStringData(Element repositoryElement) {
        HashMap<String, String> values = new HashMap<String, String>();
        List attributes = repositoryElement.attributes();
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            Attribute attr = (Attribute)iter.next();
            if (attr.getName().equals("class")) continue;
            values.put(attr.getName(), attr.getText());
        }
        List subElements = repositoryElement.elements();
        iter = null;
        iter = subElements.iterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            if (element.getName().equals("classes")) continue;
            values.put(element.getName(), element.getText());
        }
        return values;
    }

    public List getRepositoryConfigurations() {
        return this.repositoryConfigurations;
    }

    public String[] getDelegationKeyOrder() {
        if (this.delegationOrder.isEmpty()) {
            return null;
        }
        return this.delegationOrder.toArray(new String[1]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

