/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.configuration.xml;

import com.atlassian.user.configuration.Configuration;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.DefaultDelegationAccessor;
import com.atlassian.user.configuration.DefaultRepositoryConfiguration;
import com.atlassian.user.configuration.DelegationAccessor;
import com.atlassian.user.configuration.RepositoryAccessor;
import com.atlassian.user.configuration.RepositoryConfiguration;
import com.atlassian.user.configuration.xml.AtlassianUserXMLParser;
import com.atlassian.user.configuration.xml.DefaultAtlassianUserXMLParser;
import com.atlassian.user.util.ClassLoaderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class XMLConfiguration
implements Configuration {
    private static final Logger log = Logger.getLogger((Class)(class$com$atlassian$user$configuration$xml$XMLConfiguration == null ? (class$com$atlassian$user$configuration$xml$XMLConfiguration = XMLConfiguration.class$("com.atlassian.user.configuration.xml.XMLConfiguration")) : class$com$atlassian$user$configuration$xml$XMLConfiguration));
    protected String fileName = "atlassian-user.xml";
    protected AtlassianUserXMLParser xmlParser;
    protected boolean initialized;
    protected boolean initializing;
    protected DelegationAccessor delegationAccessor;
    protected List repositoryConfigs;
    protected InputStream xmlIS;
    static /* synthetic */ Class class$com$atlassian$user$configuration$xml$XMLConfiguration;

    public XMLConfiguration() {
        this.xmlParser = new DefaultAtlassianUserXMLParser();
        this.delegationAccessor = new DefaultDelegationAccessor();
    }

    public XMLConfiguration(String fileName) {
        this.fileName = fileName;
        this.xmlParser = new DefaultAtlassianUserXMLParser();
        this.delegationAccessor = new DefaultDelegationAccessor();
    }

    public XMLConfiguration(InputStream is) {
        this.xmlIS = is;
        this.xmlParser = new DefaultAtlassianUserXMLParser();
        this.delegationAccessor = new DefaultDelegationAccessor();
    }

    public DelegationAccessor getDelegationAccessor() {
        if (!this.initialized && !this.initializing) {
            try {
                this.init();
            }
            catch (ConfigurationException e) {
                throw new IllegalStateException("Atlassian User failed to initialize: " + e.getMessage());
            }
        }
        return this.delegationAccessor;
    }

    public void init() throws ConfigurationException {
        if (!this.initialized && !this.initializing) {
            this.initializing = true;
            if (this.xmlIS == null) {
                this.xmlIS = ClassLoaderUtils.getResourceAsStream(this.fileName, this.getClass());
            }
            this.xmlParser.parse(this.xmlIS);
            try {
                this.xmlIS.close();
            }
            catch (IOException e) {
                throw new ConfigurationException("Could not close inputstream on [" + this.fileName + "]: " + e.getMessage());
            }
            this.repositoryConfigs = this.xmlParser.getRepositoryConfigurations();
            this.configureRepositories();
            String[] delegationOrder = this.xmlParser.getDelegationKeyOrder();
            this.delegationAccessor.orderDelegation(delegationOrder);
            this.initialized = true;
        }
        this.initializing = false;
    }

    protected void configureRepositories() throws ConfigurationException {
        Iterator configsIter = this.repositoryConfigs.iterator();
        while (configsIter.hasNext()) {
            DefaultRepositoryConfiguration repositoryConfiguration = (DefaultRepositoryConfiguration)configsIter.next();
            RepositoryAccessor accessor = this.configureRepository(repositoryConfiguration);
            this.delegationAccessor.addRepositoryAccessor(accessor.getRepository().getKey(), accessor);
        }
    }

    protected RepositoryAccessor configureRepository(RepositoryConfiguration repositoryConfiguration) throws ConfigurationException {
        RepositoryAccessor accessor = repositoryConfiguration.configure();
        return accessor;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

