/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.cache.properties;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.cache.Cache;
import com.atlassian.user.impl.cache.CacheManager;
import com.atlassian.user.impl.ehcache.properties.CachedPropertySet;
import com.atlassian.user.properties.PropertySetFactory;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.HashMap;

public class CachingPropertySetFactory
implements PropertySetFactory {
    private PropertySetFactory underlyingPropertySetFactory;
    private CacheManager cacheManager;
    public String propertySetCacheName = null;

    public CachingPropertySetFactory() {
    }

    public CachingPropertySetFactory(PropertySetFactory underlyingPropertySetFactory, CacheManager cacheManager) {
        this.underlyingPropertySetFactory = underlyingPropertySetFactory;
        this.cacheManager = cacheManager;
    }

    public PropertySet getPropertySet(Entity entity) throws EntityException {
        Cache propertySetCache = this.cacheManager.getCache(this.propertySetCacheName);
        PropertySet propertySet = null;
        propertySet = (PropertySet)propertySetCache.get(entity.getName());
        if (propertySet == null) {
            propertySet = this.underlyingPropertySetFactory.getPropertySet(entity);
            HashMap<String, PropertySet> args = new HashMap<String, PropertySet>();
            args.put("PropertySet", propertySet);
            CachedPropertySet cachedPropertySet = new CachedPropertySet();
            cachedPropertySet.init(args, args);
            propertySetCache.put(entity.getName(), cachedPropertySet);
        }
        return propertySet;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.cacheManager = (CacheManager)args.get("cacheManager");
        this.underlyingPropertySetFactory = (PropertySetFactory)args.get("propertySetFactory");
        InitializationCheck.validateArgs(args, new String[]{"cacheManager", "propertySetFactory"}, this);
        this.propertySetCacheName = this.underlyingPropertySetFactory.getClass().getName() + ".propertysets";
    }
}

