/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.delegation.repository;

import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.repository.Repository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class DelegatingRepository
implements Repository {
    public static final transient String DELEGATING = "Delegating Repository: ";
    private transient List repositories;

    public DelegatingRepository() {
    }

    public DelegatingRepository(Repository repo1, Repository repo2) {
        this.repositories = new ArrayList();
        this.repositories.add(repo1);
        this.repositories.add(repo2);
    }

    public DelegatingRepository(List repositories) {
        this.repositories = repositories;
    }

    public String getKey() {
        StringBuffer key = new StringBuffer(DELEGATING);
        Iterator iter = this.repositories.iterator();
        while (iter.hasNext()) {
            Repository r = (Repository)iter.next();
            key.append(r.getKey() + " ");
        }
        return key.toString();
    }

    public String getName() {
        StringBuffer name = new StringBuffer(DELEGATING);
        Iterator iter = this.repositories.iterator();
        while (iter.hasNext()) {
            Repository r = (Repository)iter.next();
            name.append(r.getName() + " ");
        }
        return name.toString();
    }

    public String getDescription() {
        return DELEGATING;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.repositories = (List)args.get("repositories");
        InitializationCheck.validateArgs(args, new String[]{"repositories"}, this);
    }

    public List getRepositories() {
        return this.repositories;
    }
}

