/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.hibernate;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.DuplicateEntityException;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.hibernate.DefaultHibernateGroup;
import com.atlassian.user.impl.hibernate.DefaultHibernateUser;
import com.atlassian.user.impl.hibernate.repository.HibernateRepository;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.security.password.PasswordEncryptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

public class HibernateUserManager
extends HibernateDaoSupport
implements UserManager {
    private static final Logger log = Logger.getLogger((Class)(class$com$atlassian$user$impl$hibernate$HibernateUserManager == null ? (class$com$atlassian$user$impl$hibernate$HibernateUserManager = HibernateUserManager.class$("com.atlassian.user.impl.hibernate.HibernateUserManager")) : class$com$atlassian$user$impl$hibernate$HibernateUserManager));
    public static final String USERNAME_FIELD = "username";
    private HibernateRepository repository;
    private PasswordEncryptor passwordEncryptor;
    static /* synthetic */ Class class$com$atlassian$user$impl$hibernate$HibernateUserManager;

    public HibernateUserManager() {
    }

    public HibernateUserManager(HibernateRepository repository, PasswordEncryptor passwordEncryptor) {
        this.repository = repository;
        this.passwordEncryptor = passwordEncryptor;
        this.setSessionFactory(repository.getSessionFactory());
    }

    public Pager getUsers() throws EntityException {
        List result = null;
        try {
            result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query queryObject = session.getNamedQuery("atluser.user_findAll");
                    SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateUserManager.this.getSessionFactory());
                    return queryObject.list();
                }
            });
        }
        catch (DataAccessException e) {
            throw new RepositoryException(e);
        }
        if (result == null) {
            return new DefaultPager();
        }
        return new DefaultPager(result);
    }

    public Pager getUserNames() throws EntityException {
        List result = null;
        try {
            result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query queryObject = session.getNamedQuery("atluser.user_findAllUserNames");
                    SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateUserManager.this.getSessionFactory());
                    return queryObject.list();
                }
            });
        }
        catch (DataAccessException e) {
            throw new RepositoryException(e);
        }
        if (result == null) {
            return new DefaultPager();
        }
        return new DefaultPager(result);
    }

    public User getUser(final String username) throws EntityException {
        if (username == null) {
            throw new IllegalArgumentException("Input (username) is null.");
        }
        List result = null;
        Object foundUser = null;
        try {
            result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query queryObject = session.getNamedQuery("atluser.user_find");
                    SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateUserManager.this.getSessionFactory());
                    if (username != null) {
                        queryObject.setParameter(HibernateUserManager.USERNAME_FIELD, (Object)username);
                    }
                    return queryObject.list();
                }
            });
        }
        catch (DataAccessException e) {
            throw new RepositoryException(e);
        }
        if (result.size() == 0) {
            return null;
        }
        return (User)result.get(0);
    }

    public User createUser(String username) throws EntityException {
        if (username == null) {
            throw new IllegalArgumentException("Input (username) is null.");
        }
        User user = this.getUser(username);
        if (user != null) {
            throw new DuplicateEntityException("User with name [" + username + "] already exists in this repository" + " (" + this.repository.getName() + ")");
        }
        user = new DefaultHibernateUser(username);
        this.saveUser(user);
        return user;
    }

    public void alterPassword(User user, String password) throws EntityException {
        User foundUser = this.getUser(user.getName());
        if (foundUser == null) {
            throw new EntityException("This repository [" + this.repository.getName() + "] does not handle user [" + user.getName() + "]");
        }
        password = this.passwordEncryptor.encrypt(password);
        foundUser.setPassword(password);
        this.saveUser(foundUser);
    }

    public void saveUser(User user) throws EntityException {
        if (user == null) {
            throw new IllegalArgumentException("Input (user) is null.");
        }
        if (!this.isHandledUser(user)) {
            throw new IllegalArgumentException("User is not a Hibernate entity [" + user.getClass().getName());
        }
        DefaultHibernateUser dUser = (DefaultHibernateUser)user;
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)dUser);
            this.getSession().flush();
        }
        catch (HibernateException e) {
            throw new RepositoryException(e);
        }
    }

    public void removeUser(User user) throws EntityException {
        if (user == null) {
            throw new IllegalArgumentException("Input (username) is null.");
        }
        if (!this.isHandledUser(user)) {
            throw new IllegalArgumentException("User is not a Hibernate entity [" + user.getClass().getName());
        }
        DefaultHibernateUser dUser = (DefaultHibernateUser)user;
        Set groups = dUser.getGroups();
        if (groups != null) {
            dUser.setGroups(null);
            Iterator groupsOfUser = groups.iterator();
            while (groupsOfUser.hasNext()) {
                DefaultHibernateGroup group = (DefaultHibernateGroup)groupsOfUser.next();
                Set members = group.getLocalMembers();
                if (members != null) {
                    members.remove(user);
                }
                this.getHibernateTemplate().saveOrUpdate((Object)group);
            }
        }
        this.getHibernateTemplate().delete((Object)user);
    }

    private boolean isHandledUser(User user) {
        return user instanceof DefaultHibernateUser;
    }

    public boolean isReadOnly(User user) throws EntityException {
        return false;
    }

    public PasswordEncryptor getPasswordEncryptor(User user) throws EntityException {
        return this.passwordEncryptor;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Repository getRepository(Entity entity) throws EntityException {
        if (this.getUser(entity.getName()) != null) {
            return this.repository;
        }
        return null;
    }

    public boolean isCreative() {
        return true;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.repository = (HibernateRepository)args.get("repository");
        this.passwordEncryptor = (PasswordEncryptor)args.get("passwordEncryptor");
        InitializationCheck.validateArgs(args, new String[]{"repository", "passwordEncryptor"}, this);
        this.setSessionFactory(this.repository.getSessionFactory());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

