/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.adaptor;

import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.ldap.LDAPEntity;
import com.atlassian.user.impl.ldap.LDAPGroupFactory;
import com.atlassian.user.impl.ldap.LDAPUserFactory;
import com.atlassian.user.impl.ldap.adaptor.AbstractLDAPGroupAdaptor;
import com.atlassian.user.impl.ldap.repository.LDAPRepository;
import com.atlassian.user.impl.ldap.search.DefaultLDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.LDAPPagerInfo;
import com.atlassian.user.impl.ldap.search.LDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.page.LDAPEntityPager;
import com.atlassian.user.impl.ldap.search.page.LDAPMembershipToUsernamePager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class LDAPStaticGroupAdaptor
extends AbstractLDAPGroupAdaptor {
    private static final Logger log = Logger.getLogger((Class)(class$com$atlassian$user$impl$ldap$adaptor$LDAPStaticGroupAdaptor == null ? (class$com$atlassian$user$impl$ldap$adaptor$LDAPStaticGroupAdaptor = LDAPStaticGroupAdaptor.class$("com.atlassian.user.impl.ldap.adaptor.LDAPStaticGroupAdaptor")) : class$com$atlassian$user$impl$ldap$adaptor$LDAPStaticGroupAdaptor));
    private LDAPUserAdaptor userAdaptor;
    private LDAPUserFactory userFactory;
    static /* synthetic */ Class class$com$atlassian$user$impl$ldap$adaptor$LDAPStaticGroupAdaptor;
    static /* synthetic */ Class class$com$atlassian$user$impl$ldap$LDAPEntity;

    public LDAPStaticGroupAdaptor() {
    }

    public LDAPStaticGroupAdaptor(LDAPRepository repository, LDAPGroupFactory groupFactory, LDAPUserFactory userFactory) {
        super(repository, groupFactory);
        this.userAdaptor = new DefaultLDAPUserAdaptor(repository);
        this.userFactory = userFactory;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.repository = (LDAPRepository)args.get("repository");
        this.groupFactory = (LDAPGroupFactory)args.get("groupFactory");
        this.userAdaptor = (LDAPUserAdaptor)args.get("userAdaptor");
        this.userFactory = (LDAPUserFactory)args.get("userFactory");
        InitializationCheck.validateArgs(args, new String[]{"repository", "groupFactory", "userAdaptor", "userFactory"}, this);
    }

    public Pager getGroups(User user) throws EntityException {
        LDAPPagerInfo info = this.getGroupEntriesViaMembership(user);
        if (info == null) {
            return null;
        }
        return new LDAPEntityPager(this.repository, this.groupFactory, info);
    }

    public Pager findMembers(Group group) throws EntityException {
        LDAPPagerInfo info = this.getGroupEntries(group.getName(), new String[]{this.repository.getMembershipAttribute()}, null);
        return new LDAPMembershipToUsernamePager(this.repository, info);
    }

    public Pager findMemberNames(Group group) throws EntityException {
        LDAPPagerInfo info = this.getGroupEntries(group.getName(), new String[]{this.repository.getMembershipAttribute()}, null);
        return new LDAPMembershipToUsernamePager(this.repository, info);
    }

    public boolean hasStaticGroups() {
        return true;
    }

    public boolean hasMembership(Group group, User user) throws RepositoryException {
        if (!(user instanceof LDAPEntity)) {
            return false;
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_hasMembership(" + group + ", " + user + ")"));
        }
        String searchFilter = "(&(" + this.repository.getGroupnameAttribute() + "=" + group.getName() + ")(" + this.repository.getMembershipAttribute() + "=" + ((LDAPEntity)((Object)user)).getDistinguishedName() + "))";
        String[] attributesToReturn = new String[]{this.repository.getGroupnameAttribute()};
        LDAPPagerInfo result = this.search(searchFilter, attributesToReturn);
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_hasMembership(" + group + ", " + user + ")"));
        }
        return result.getNamingEnumeration().hasMoreElements();
    }

    public LDAPPagerInfo getGroupEntriesViaMembership(User user) throws EntityException {
        if (!(user instanceof LDAPEntity)) {
            log.info((Object)("Membership check for a non " + (class$com$atlassian$user$impl$ldap$LDAPEntity == null ? (class$com$atlassian$user$impl$ldap$LDAPEntity = LDAPStaticGroupAdaptor.class$("com.atlassian.user.impl.ldap.LDAPEntity")) : class$com$atlassian$user$impl$ldap$LDAPEntity).getName()));
            return this.getGroupEntriesViaMembership(user.getName());
        }
        LDAPEntity entity = (LDAPEntity)((Object)user);
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_getLDAPGroupEntriesViaLDAPUser(" + user.getName() + ")"));
        }
        String searchTerm = null;
        LDAPPagerInfo ldapGroupPagerInfo = null;
        try {
            String[] attributesToReturn = new String[]{this.repository.getGroupnameAttribute()};
            searchTerm = "(" + this.repository.getMembershipAttribute() + "=" + entity.getDistinguishedName() + ")";
            ldapGroupPagerInfo = this.getGroupEntries(attributesToReturn, searchTerm);
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e);
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_getLDAPGroupEntriesViaLDAPUser(" + user.getName() + ")"));
        }
        return ldapGroupPagerInfo;
    }

    public LDAPPagerInfo getGroupEntriesViaMembership(String userSearchPattern) throws EntityException {
        return this.getGroupEntriesViaMembership(userSearchPattern, null);
    }

    public LDAPPagerInfo getGroupEntriesViaMembership(String userSearchPattern, String[] attributesToReturn) throws EntityException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_getLDAPGroupEntriesViaMembership(" + userSearchPattern + ")"));
        }
        String searchTerm = null;
        LDAPPagerInfo ldapGroupPagerInfo = null;
        try {
            if (attributesToReturn == null) {
                attributesToReturn = new String[]{this.repository.getGroupnameAttribute()};
            }
            searchTerm = "(" + this.repository.getMembershipAttribute() + "=" + this.userAdaptor.getUserDN(userSearchPattern) + ")";
            ldapGroupPagerInfo = this.getGroupEntries(attributesToReturn, searchTerm);
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e);
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_getLDAPGroupEntriesViaMembership(" + userSearchPattern + ")"));
        }
        return ldapGroupPagerInfo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

