/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.osuser;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.DuplicateEntityException;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.osuser.OSUAccessor;
import com.atlassian.user.impl.osuser.OSUEntityManager;
import com.atlassian.user.impl.osuser.OSUGroup;
import com.atlassian.user.impl.osuser.OSUUser;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.EntityNameAlphaComparator;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.opensymphony.user.ImmutableException;
import com.opensymphony.user.ManagerAccessor;
import com.opensymphony.user.provider.AccessProvider;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class OSUGroupManager
extends OSUEntityManager
implements GroupManager {
    private OSUAccessor osuserAccessor;
    private AccessProvider accessProvider;
    private UserManager userManager;

    public OSUGroupManager() {
    }

    public OSUGroupManager(Repository repository, UserManager osUserManager, OSUAccessor accessor) throws EntityException {
        super(repository);
        this.userManager = osUserManager;
        this.osuserAccessor = accessor;
        this.accessProvider = accessor.getAccessProvider();
    }

    public void init(HashMap args) throws ConfigurationException {
        this.repository = (Repository)args.get("repository");
        this.userManager = (UserManager)args.get("userManager");
        this.osuserAccessor = (OSUAccessor)args.get("accessor");
        this.accessProvider = this.osuserAccessor.getAccessProvider();
        InitializationCheck.validateArgs(args, new String[]{"repository", "userManager", "accessor"}, this);
    }

    public Pager getGroups() {
        List groupNames = this.accessProvider.list();
        TreeSet<Group> atlassianGroups = new TreeSet<Group>(EntityNameAlphaComparator.getInstance());
        Iterator iterator = groupNames.iterator();
        while (iterator.hasNext()) {
            String groupName = (String)iterator.next();
            Group atlassianGroup = this.getGroup(groupName);
            if (atlassianGroup == null) continue;
            atlassianGroups.add(atlassianGroup);
        }
        return new DefaultPager(atlassianGroups);
    }

    public Group createGroup(String groupName) throws EntityException {
        OSUGroup group = null;
        if (this.accessProvider.handles(groupName)) {
            throw new DuplicateEntityException("Group named [" + groupName + "] already exists in accessProvider [" + this.accessProvider.toString());
        }
        if (this.accessProvider.create(groupName)) {
            group = new OSUGroup(new com.opensymphony.user.Group(groupName, (ManagerAccessor)this.osuserAccessor));
        }
        return group;
    }

    public void removeGroup(Group group) throws EntityException, IllegalArgumentException {
        if (group == null) {
            throw new IllegalArgumentException("Group is null.");
        }
        if (!(group instanceof OSUGroup)) {
            throw new IllegalArgumentException("User is not a OSUGroup [" + group.getClass().getName());
        }
        Group groupToRemove = this.getGroup(group.getName());
        ArrayList users = this.accessProvider.listUsersInGroup(groupToRemove.getName());
        users = new ArrayList(users);
        for (int i = 0; i < users.size(); ++i) {
            String username = (String)users.get(i);
            this.accessProvider.removeFromGroup(username, groupToRemove.getName());
        }
        this.accessProvider.remove(group.getName());
    }

    public void addMembership(Group group, User user) {
        if (this.getGroup(group.getName()) == null) {
            return;
        }
        this.accessProvider.addToGroup(user.getName(), group.getName());
    }

    public boolean hasMembership(Group group, User user) {
        if (!(group instanceof OSUGroup)) {
            return false;
        }
        return this.accessProvider.inGroup(user.getName(), group.getName());
    }

    private com.opensymphony.user.Group getOpenSymphonyGroup(String groupName) {
        if (this.accessProvider.handles(groupName)) {
            return new com.opensymphony.user.Group(groupName, (ManagerAccessor)this.osuserAccessor);
        }
        return null;
    }

    public void removeMembership(Group group, User user) {
        OSUGroup osgroup = (OSUGroup)group;
        OSUUser osuser = (OSUUser)user;
        this.accessProvider.removeFromGroup(user.getName(), group.getName());
    }

    public boolean isReadOnly(Group group) throws EntityException {
        return !this.accessProvider.handles(group.getName());
    }

    public boolean supportsExternalMembership() throws EntityException {
        return false;
    }

    public boolean supportsExternalMembership(Group group, User user) throws EntityException {
        return user instanceof OSUUser && this.osuserAccessor.getCredentialsProvider().handles(user.getName());
    }

    public Pager getMemberNames(Group group) throws EntityException {
        TreeSet<Object> atlUsers = new TreeSet<Object>(Collator.getInstance());
        if (!(group instanceof OSUGroup)) {
            return new DefaultPager(atlUsers);
        }
        List memberNames = this.accessProvider.listUsersInGroup(group.getName());
        Iterator iterator = memberNames.iterator();
        while (iterator.hasNext()) {
            Object memberName = iterator.next();
            if (memberName == null) continue;
            atlUsers.add(memberName);
        }
        return new DefaultPager(atlUsers);
    }

    public Pager getLocalMemberNames(Group group) throws EntityException {
        TreeSet atlUsers = new TreeSet(EntityNameAlphaComparator.getInstance());
        if (!(group instanceof OSUGroup)) {
            return new DefaultPager(atlUsers);
        }
        List memberNames = this.accessProvider.listUsersInGroup(group.getName());
        Collections.sort(memberNames, EntityNameAlphaComparator.getInstance());
        return new DefaultPager(memberNames);
    }

    public Pager getExternalMemberNames(Group group) throws EntityException {
        throw new UnsupportedOperationException("External membership is not supported.");
    }

    public void saveGroup(Group group) throws EntityException {
        if (!this.accessProvider.handles(group.getName())) {
            return;
        }
        com.opensymphony.user.Group g = new com.opensymphony.user.Group(group.getName(), (ManagerAccessor)this.osuserAccessor);
        try {
            g.store();
        }
        catch (ImmutableException e) {
            throw new RepositoryException(e);
        }
    }

    public Group getGroup(String groupName) {
        if (!this.accessProvider.handles(groupName)) {
            return null;
        }
        OSUGroup group = null;
        com.opensymphony.user.Group osgroup = new com.opensymphony.user.Group(groupName, (ManagerAccessor)this.osuserAccessor);
        if (osgroup != null) {
            group = new OSUGroup(osgroup);
        }
        return group;
    }

    public Pager getGroups(User user) throws RepositoryException {
        TreeSet<Group> groupsForUser = new TreeSet<Group>(EntityNameAlphaComparator.getInstance());
        List groupNamesForUser = null;
        try {
            groupNamesForUser = this.accessProvider.listGroupsContainingUser(user.getName());
            Iterator iterator = groupNamesForUser.iterator();
            while (iterator.hasNext()) {
                String groupName = (String)iterator.next();
                groupsForUser.add(this.getGroup(groupName));
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        return groupsForUser == null ? new DefaultPager() : new DefaultPager(groupsForUser);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Repository getRepository(Entity entity) throws EntityException {
        if (this.getGroup(entity.getName()) != null) {
            return this.repository;
        }
        return null;
    }

    public boolean isCreative() {
        List groups = this.accessProvider.list();
        if (groups.isEmpty()) {
            return true;
        }
        String groupName = groups.toArray(new String[0])[0];
        return new com.opensymphony.user.Group(groupName, (ManagerAccessor)this.osuserAccessor).isMutable();
    }

    public void setAccessor(OSUAccessor OSUAccessor2) {
        this.osuserAccessor = OSUAccessor2;
    }

    public void setAccessProvider(AccessProvider accessProvider) {
        this.accessProvider = accessProvider;
    }
}

