/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.search.page;

import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;

public class MergedListPager
implements Pager {
    private static final Category log = Category.getInstance((Class)(class$com$atlassian$user$search$page$MergedListPager == null ? (class$com$atlassian$user$search$page$MergedListPager = MergedListPager.class$("com.atlassian.user.search.page.MergedListPager")) : class$com$atlassian$user$search$page$MergedListPager));
    private List pagers;
    private int combinedIndex;
    public Pager currentPager;
    private List currentPage;
    private int indexOfFirstItemInCurrentPage;
    private boolean onLastPage = false;
    static /* synthetic */ Class class$com$atlassian$user$search$page$MergedListPager;

    MergedListPager(List pagers) {
        this.pagers = pagers;
    }

    public boolean isEmpty() {
        Iterator iter = this.pagers.iterator();
        while (iter.hasNext()) {
            Pager pager = (Pager)iter.next();
            if (pager.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Iterator iterator() {
        if (this.pagers == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new MergedListIterator(this.pagers);
    }

    public List getCurrentPage() {
        if (this.currentPage == null) {
            this.currentPage = new ArrayList();
            this.indexOfFirstItemInCurrentPage = this.combinedIndex;
            Iterator iterator = this.iterator();
            while (iterator.hasNext() && this.currentPage.size() < 100) {
                this.currentPage.add(iterator.next());
                ++this.combinedIndex;
            }
            if (this.currentPage.size() < 100 || !this.iterator().hasNext()) {
                this.onLastPage = true;
            }
        }
        return this.currentPage;
    }

    public void nextPage() {
        try {
            this.skipTo(this.combinedIndex + (this.currentPage == null ? 100 : 0));
        }
        catch (PagerException e) {
            log.error((Object)"Erroring calling nextPage()", (Throwable)e);
        }
    }

    public boolean onLastPage() {
        return this.onLastPage;
    }

    public void skipTo(int index) throws PagerException {
        if (index < this.combinedIndex) {
            throw new PagerException("Cannot run the index back to [" + index + "] from [" + this.combinedIndex + "]");
        }
        while (this.combinedIndex < index) {
            this.iterator().next();
            ++this.combinedIndex;
        }
        this.currentPage = null;
        this.getCurrentPage();
    }

    public int getIndex() {
        return this.combinedIndex;
    }

    public int getIndexOfFirstItemInCurrentPage() {
        this.getCurrentPage();
        return this.indexOfFirstItemInCurrentPage;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MergedListIterator
    implements Iterator {
        private List iterators = new ArrayList();

        public MergedListIterator(List listOfPagers) {
            Iterator i = listOfPagers.iterator();
            while (i.hasNext()) {
                Pager pager = (Pager)i.next();
                this.iterators.add(pager.iterator());
            }
        }

        private Iterator getCurrentIterator() {
            for (int i = 0; i < this.iterators.size(); ++i) {
                Iterator iterator = (Iterator)this.iterators.get(i);
                if (!iterator.hasNext()) continue;
                return iterator;
            }
            return Collections.EMPTY_LIST.iterator();
        }

        public void remove() {
            throw new UnsupportedOperationException("This iterator does not support removal");
        }

        public boolean hasNext() {
            return this.getCurrentIterator().hasNext();
        }

        public Object next() {
            Object nextElement = this.getCurrentIterator().next();
            if (!this.hasNext()) {
                MergedListPager.this.onLastPage = true;
            }
            return nextElement;
        }
    }
}

