/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.leftnavigation;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.extra.leftnavigation.LeftNavSettings;
import com.atlassian.confluence.extra.leftnavigation.SettingsManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;

public class LeftNavVelocityHelper {
    public static final String DEFAULT_NAVIGATION_PAGE_NAME = "Navigation";
    private PageManager pageManager;
    private WikiStyleRenderer wikiStyleRenderer;
    private BandanaManager bandanaManager;
    private ThemeManager themeManager;

    public boolean hasNavigation(String spaceKey) {
        return this.getNavigationPage(spaceKey) != null;
    }

    public String renderNavigation(String spaceKey) {
        Page page = this.getNavigationPage(spaceKey);
        if (page == null) {
            return "";
        }
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)new PageContext(spaceKey), page.getContent());
    }

    private Page getNavigationPage(String spaceKey) {
        LeftNavSettings settings;
        SettingsManager settingsManager = new SettingsManager(this.bandanaManager);
        if (spaceKey != null && (settings = this.getSpaceLevelSettings(spaceKey, settingsManager)) != null) {
            return this.pageManager.getPage(spaceKey, settings.getPage());
        }
        settings = settingsManager.getGlobalThemeSettings();
        if (settings != null) {
            String space = settings.getSpace() == null ? spaceKey : settings.getSpace();
            return this.pageManager.getPage(space, settings.getPage());
        }
        return this.pageManager.getPage(spaceKey, DEFAULT_NAVIGATION_PAGE_NAME);
    }

    public LeftNavSettings getSpaceLevelSettings(String spaceKey, SettingsManager settingsManager) {
        if (this.themeManager.getSpaceThemeKey(spaceKey) != null && this.themeManager.getSpaceThemeKey(spaceKey).equalsIgnoreCase(settingsManager.THEMEKEY)) {
            LeftNavSettings settings = settingsManager.getSpaceThemeSettings(spaceKey);
            return settings;
        }
        return null;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public void setThemeManager(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }
}

