/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.yourkit;

import com.atlassian.confluence.core.Administrative;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.yourkit.api.Controller;
import org.apache.log4j.Logger;

public class CpuSnapshotAction
extends ConfluenceActionSupport
implements Administrative {
    private static final Logger log = Logger.getLogger((Class)CpuSnapshotAction.class);

    public String execute() throws Exception {
        Controller controller;
        try {
            controller = new Controller();
        }
        catch (Exception e) {
            this.addActionError("Please ensure Confluence is started with the profiler libraries.");
            log.error((Object)("Failure to get YourKit controller - ensure profiling libraries present: " + e), (Throwable)e);
            return "error";
        }
        catch (NoClassDefFoundError e) {
            this.addActionError("Please ensure Confluence is started with the profiler libraries.");
            log.error((Object)("Failure to get YourKit controller - ensure profiling libraries present: " + e), (Throwable)e);
            return "error";
        }
        try {
            controller.startCPUTimesAndCountsMeasuring();
        }
        catch (Exception e) {
            this.addActionError("Agent failed to start CPU profiling for the following reason: " + e.getMessage());
            log.error((Object)("Failure starting CPU profiling: " + e), (Throwable)e);
            return "error";
        }
        log.warn((Object)"CPU profiling started. This thread will now sleep for 30 seconds");
        Thread.sleep(30000L);
        try {
            long start = System.currentTimeMillis();
            String location = controller.captureCPUSnapshot(false);
            this.addActionMessage("Captured snapshot (" + (System.currentTimeMillis() - start) / 1000L + "secs) to: " + location);
        }
        catch (Exception e) {
            this.addActionError("Agent failed to capture snapshot for the following reason: " + e.getMessage());
            log.error((Object)("Failure to capture snapshot: " + e), (Throwable)e);
            return "error";
        }
        return "success";
    }
}

