/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paddle.connection;

import com.atlassian.paddle.configuration.Configuration;
import com.atlassian.paddle.connection.ConnectionProperties;
import org.apache.log4j.Logger;

public class DefaultConnectionProperties
implements ConnectionProperties {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final Configuration configuration;
    private final long resultCount;

    public DefaultConnectionProperties(Configuration configuration, long batchSize) {
        this.configuration = configuration;
        this.resultCount = batchSize;
    }

    public String getProviderUrl() {
        String host = this.configuration.getAttributeWarnIfMissing("host", this.logger);
        String port = this.configuration.getAttributeWarnIfMissing("port", this.logger);
        return "ldap://" + host + ":" + port;
    }

    public String getSecurityProtocol() {
        return this.configuration.getAttributeWarnIfMissing("securityProtocol", this.logger);
    }

    public String getBatchSize() {
        return String.valueOf(this.resultCount);
    }

    public boolean isAnonymousAuthentication() {
        return this.getSecurityAuthentication() != null && this.getSecurityAuthentication().equals("none");
    }

    public String getUsername() {
        String username = this.configuration.getAttribute("securityPrincipal");
        if (username == null && !this.isAnonymousAuthentication()) {
            this.logger.warn("Username is missing from configuration, and anonymous authentication not configured");
        }
        return username;
    }

    public String getPassword() {
        String password = this.configuration.getAttribute("securityCredential");
        if (password == null && !this.isAnonymousAuthentication()) {
            this.logger.warn("Password is missing from configuration, and anonymous authentication not configured");
        }
        return password;
    }

    public String getSecurityAuthentication() {
        return this.configuration.getAttributeWarnIfMissing("securityAuthentication", this.logger);
    }
}

