/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paddle.search;

import com.atlassian.paddle.configuration.Configuration;
import com.atlassian.paddle.filter.LiteralFilter;
import com.atlassian.paddle.search.AbstractSearch;
import net.sf.ldaptemplate.support.filter.AndFilter;
import net.sf.ldaptemplate.support.filter.EqualsFilter;
import org.apache.log4j.Logger;

public class GroupsForUserSearch
extends AbstractSearch {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final Configuration configuration;
    private final String userDn;

    public GroupsForUserSearch(Configuration configuration, String userDn) {
        this.configuration = configuration;
        this.userDn = userDn;
    }

    public String getBaseDn() {
        return this.configuration.getAttributeWarnIfMissing("baseGroupNamespace", this.logger);
    }

    public String getFilter() {
        String membershipAttribute = this.configuration.getAttributeWarnIfMissing("membershipAttribute", this.logger);
        String groupSearchFilter = this.configuration.getAttributeWarnIfMissing("groupSearchFilter", this.logger);
        AndFilter andFilter = new AndFilter();
        andFilter.and(new LiteralFilter(groupSearchFilter));
        andFilter.and(new EqualsFilter(membershipAttribute, this.userDn));
        return andFilter.toString();
    }

    protected String[] getAttributesToReturn() {
        return new String[0];
    }
}

