--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: postgres81
--

COMMENT ON SCHEMA public IS 'Standard public schema';


SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: attachmentdata; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE attachmentdata (
    attachmentdataid bigint NOT NULL,
    attversion integer NOT NULL,
    data bytea,
    attachmentid bigint
);


ALTER TABLE public.attachmentdata OWNER TO postgres;

--
-- Name: attachments; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE attachments (
    attachmentid bigint NOT NULL,
    title character varying(255) NOT NULL,
    contenttype character varying(255) NOT NULL,
    pageid bigint NOT NULL,
    creator character varying(255),
    creationdate timestamp without time zone,
    lastmodifier character varying(255),
    lastmoddate timestamp without time zone,
    filesize bigint,
    attachment_comment character varying(255),
    attversion integer,
    prevver bigint
);


ALTER TABLE public.attachments OWNER TO postgres;

--
-- Name: bandana; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE bandana (
    bandanaid bigint NOT NULL,
    bandanacontext character varying(255),
    bandanakey character varying(100),
    bandanavalue text
);


ALTER TABLE public.bandana OWNER TO postgres;

--
-- Name: bodycontent; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE bodycontent (
    bodycontentid bigint NOT NULL,
    body text,
    contentid bigint
);


ALTER TABLE public.bodycontent OWNER TO postgres;

--
-- Name: clustersafety; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE clustersafety (
    clustersafetyid bigint NOT NULL,
    safetynumber integer
);


ALTER TABLE public.clustersafety OWNER TO postgres;

--
-- Name: confancestors; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE confancestors (
    descendentid bigint NOT NULL,
    ancestorid bigint NOT NULL,
    ancestorposition integer NOT NULL
);


ALTER TABLE public.confancestors OWNER TO postgres;

--
-- Name: confversion; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE confversion (
    confversionid bigint NOT NULL,
    buildnumber integer NOT NULL,
    installdate timestamp without time zone,
    versiontag character varying(255),
    creationdate timestamp without time zone,
    lastmoddate timestamp without time zone
);


ALTER TABLE public.confversion OWNER TO postgres;

--
-- Name: content; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE content (
    contentid bigint NOT NULL,
    contenttype character varying(255) NOT NULL,
    title character varying(255),
    version integer,
    creator character varying(255),
    creationdate timestamp without time zone,
    lastmodifier character varying(255),
    lastmoddate timestamp without time zone,
    versioncomment text,
    prevver bigint,
    content_status character varying(255),
    spaceid bigint,
    child_position integer,
    parentid bigint,
    messageid character varying(255),
    draftpageid character varying(255),
    draftspacekey character varying(255),
    drafttype character varying(255),
    draftpageversion integer,
    pageid bigint,
    parentcommentid bigint,
    username character varying(255)
);


ALTER TABLE public.content OWNER TO postgres;

--
-- Name: content_label; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE content_label (
    id bigint NOT NULL,
    labelid bigint NOT NULL,
    contentid bigint NOT NULL,
    spacekey character varying(255),
    "owner" character varying(255),
    creationdate timestamp without time zone,
    lastmoddate timestamp without time zone
);


ALTER TABLE public.content_label OWNER TO postgres;

--
-- Name: content_perm; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE content_perm (
    id bigint NOT NULL,
    cp_type character varying(10) NOT NULL,
    username character varying(255),
    groupname character varying(255),
    cps_id bigint,
    creator character varying(255),
    creationdate timestamp without time zone,
    lastmodifier character varying(255),
    lastmoddate timestamp without time zone
);


ALTER TABLE public.content_perm OWNER TO postgres;

--
-- Name: content_perm_set; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE content_perm_set (
    id bigint NOT NULL,
    cont_perm_type character varying(10) NOT NULL,
    content_id bigint,
    creationdate timestamp without time zone,
    lastmoddate timestamp without time zone
);


ALTER TABLE public.content_perm_set OWNER TO postgres;

--
-- Name: contentlock; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE contentlock (
    contentlockid bigint NOT NULL,
    title character varying(20),
    groupname character varying(255),
    expirydate timestamp without time zone,
    content bigint,
    creator character varying(255),
    commentstr character varying(255),
    creationdate timestamp without time zone,
    lastmodifier character varying(255),
    lastmoddate timestamp without time zone
);


ALTER TABLE public.contentlock OWNER TO postgres;

--
-- Name: decorator; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE decorator (
    decoratorid bigint NOT NULL,
    spacekey character varying(255),
    decoratorname character varying(255),
    body text,
    lastmoddate timestamp without time zone
);


ALTER TABLE public.decorator OWNER TO postgres;

--
-- Name: external_entities; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE external_entities (
    id bigint NOT NULL,
    name character varying(255),
    "type" character varying(255) NOT NULL
);


ALTER TABLE public.external_entities OWNER TO postgres;

--
-- Name: external_members; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE external_members (
    extentityid bigint NOT NULL,
    groupid bigint NOT NULL
);


ALTER TABLE public.external_members OWNER TO postgres;

--
-- Name: extrnlnks; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE extrnlnks (
    linkid bigint NOT NULL,
    contenttype character varying(255) NOT NULL,
    viewcount integer NOT NULL,
    url character varying(255) NOT NULL,
    contentid bigint NOT NULL,
    creator character varying(255),
    creationdate timestamp without time zone,
    lastmodifier character varying(255),
    lastmoddate timestamp without time zone
);


ALTER TABLE public.extrnlnks OWNER TO postgres;

--
-- Name: groups; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE groups (
    id bigint NOT NULL,
    groupname character varying(255) NOT NULL
);


ALTER TABLE public.groups OWNER TO postgres;

--
-- Name: hibernate_unique_key; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE hibernate_unique_key (
    next_hi integer
);


ALTER TABLE public.hibernate_unique_key OWNER TO postgres;

--
-- Name: indexqueueentries; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE indexqueueentries (
    entryid bigint NOT NULL,
    creationdate timestamp without time zone,
    "type" integer,
    handle character varying(255)
);


ALTER TABLE public.indexqueueentries OWNER TO postgres;

--
-- Name: keystore; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE keystore (
    keyid bigint NOT NULL,
    alias character varying(255) NOT NULL,
    "type" character varying(32) NOT NULL,
    algorithm character varying(32) NOT NULL,
    keyspec text NOT NULL
);


ALTER TABLE public.keystore OWNER TO postgres;

--
-- Name: label; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE label (
    labelid bigint NOT NULL,
    name character varying(255),
    "owner" character varying(255),
    namespace character varying(255),
    creationdate timestamp without time zone,
    lastmoddate timestamp without time zone
);


ALTER TABLE public.label OWNER TO postgres;

--
-- Name: links; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE links (
    linkid bigint NOT NULL,
    destpagetitle character varying(255),
    destspacekey character varying(255) NOT NULL,
    contentid bigint NOT NULL,
    creator character varying(255),
    creationdate timestamp without time zone,
    lastmodifier character varying(255),
    lastmoddate timestamp without time zone
);


ALTER TABLE public.links OWNER TO postgres;

--
-- Name: local_members; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE local_members (
    userid bigint NOT NULL,
    groupid bigint NOT NULL
);


ALTER TABLE public.local_members OWNER TO postgres;

--
-- Name: notifications; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE notifications (
    notificationid bigint NOT NULL,
    pageid bigint,
    spaceid bigint,
    username character varying(255) NOT NULL,
    creator character varying(255),
    creationdate timestamp without time zone,
    lastmodifier character varying(255),
    lastmoddate timestamp without time zone
);


ALTER TABLE public.notifications OWNER TO postgres;

--
-- Name: os_group; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE os_group (
    id bigint NOT NULL,
    groupname character varying(255) NOT NULL
);


ALTER TABLE public.os_group OWNER TO postgres;

--
-- Name: os_propertyentry; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE os_propertyentry (
    entity_name character varying(125) NOT NULL,
    entity_id bigint NOT NULL,
    entity_key character varying(200) NOT NULL,
    key_type integer,
    boolean_val boolean,
    double_val double precision,
    string_val character varying(255),
    text_val text,
    long_val bigint,
    int_val integer,
    date_val timestamp without time zone
);


ALTER TABLE public.os_propertyentry OWNER TO postgres;

--
-- Name: os_user; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE os_user (
    id bigint NOT NULL,
    username character varying(255) NOT NULL,
    passwd character varying(255)
);


ALTER TABLE public.os_user OWNER TO postgres;

--
-- Name: os_user_group; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE os_user_group (
    group_id bigint NOT NULL,
    user_id bigint NOT NULL
);


ALTER TABLE public.os_user_group OWNER TO postgres;

--
-- Name: pagetemplates; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE pagetemplates (
    templateid bigint NOT NULL,
    templatename character varying(255) NOT NULL,
    templatedesc character varying(255),
    labels character varying(255),
    content text,
    spaceid bigint,
    prevver bigint,
    version integer NOT NULL,
    creator character varying(255),
    creationdate timestamp without time zone,
    lastmodifier character varying(255),
    lastmoddate timestamp without time zone
);


ALTER TABLE public.pagetemplates OWNER TO postgres;

--
-- Name: plugindata; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE plugindata (
    plugindataid bigint NOT NULL,
    pluginkey character varying(255) NOT NULL,
    filename character varying(255) NOT NULL,
    lastmoddate timestamp without time zone,
    data bytea
);


ALTER TABLE public.plugindata OWNER TO postgres;

--
-- Name: spacegroups; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE spacegroups (
    spacegroupid bigint NOT NULL,
    spacegroupname character varying(255),
    spacegroupkey character varying(255) NOT NULL,
    licensekey text,
    creator character varying(255),
    creationdate timestamp without time zone,
    lastmodifier character varying(255),
    lastmoddate timestamp without time zone
);


ALTER TABLE public.spacegroups OWNER TO postgres;

--
-- Name: spacepermissions; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE spacepermissions (
    permid bigint NOT NULL,
    spaceid bigint,
    permtype character varying(255) NOT NULL,
    permgroupname character varying(255),
    permusername character varying(255),
    creator character varying(255),
    creationdate timestamp without time zone,
    lastmodifier character varying(255),
    lastmoddate timestamp without time zone
);


ALTER TABLE public.spacepermissions OWNER TO postgres;

--
-- Name: spaces; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE spaces (
    spaceid bigint NOT NULL,
    spacename character varying(255),
    spacekey character varying(255) NOT NULL,
    spacedescid bigint,
    homepage bigint,
    creator character varying(255),
    creationdate timestamp without time zone,
    lastmodifier character varying(255),
    lastmoddate timestamp without time zone,
    spacetype character varying(255),
    spacegroupid bigint
);


ALTER TABLE public.spaces OWNER TO postgres;

--
-- Name: trackbacklinks; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE trackbacklinks (
    linkid bigint NOT NULL,
    contenttype character varying(255) NOT NULL,
    viewcount integer NOT NULL,
    url character varying(255) NOT NULL,
    title character varying(255),
    blogname character varying(255),
    excerpt character varying(255),
    contentid bigint NOT NULL,
    creator character varying(255),
    creationdate timestamp without time zone,
    lastmodifier character varying(255),
    lastmoddate timestamp without time zone
);


ALTER TABLE public.trackbacklinks OWNER TO postgres;

--
-- Name: trustedapp; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE trustedapp (
    trustedappid bigint NOT NULL,
    name character varying(255) NOT NULL,
    timeout integer NOT NULL,
    public_key_id bigint NOT NULL
);


ALTER TABLE public.trustedapp OWNER TO postgres;

--
-- Name: trustedapprestriction; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE trustedapprestriction (
    trustedapprestrictionid bigint NOT NULL,
    "type" character varying(32) NOT NULL,
    restriction character varying(255),
    trustedappid bigint
);


ALTER TABLE public.trustedapprestriction OWNER TO postgres;

--
-- Name: users; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE users (
    id bigint NOT NULL,
    name character varying(255) NOT NULL,
    "password" character varying(255),
    email character varying(255),
    created timestamp without time zone,
    fullname character varying(255)
);


ALTER TABLE public.users OWNER TO postgres;

--
-- Data for Name: attachmentdata; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY attachmentdata (attachmentdataid, attversion, data, attachmentid) FROM stdin;
\.


--
-- Data for Name: attachments; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY attachments (attachmentid, title, contenttype, pageid, creator, creationdate, lastmodifier, lastmoddate, filesize, attachment_comment, attversion, prevver) FROM stdin;
\.


--
-- Data for Name: bandana; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY bandana (bandanaid, bandanacontext, bandanakey, bandanavalue) FROM stdin;
1	_GLOBAL	atlassian.confluence.settings	<settings>\n  <allowCamelCase>false</allowCamelCase>\n  <allowTrackbacks>false</allowTrackbacks>\n  <allowThreadedComments>true</allowThreadedComments>\n  <viewSpaceGoesToSpaceSummary>false</viewSpaceGoesToSpaceSummary>\n  <externalUserManagement>false</externalUserManagement>\n  <denyPublicSignup>false</denyPublicSignup>\n  <emailAdminMessageOff>false</emailAdminMessageOff>\n  <almostSupportPeriodEndMessageOff>false</almostSupportPeriodEndMessageOff>\n  <supportPeriodEndMessageOff>false</supportPeriodEndMessageOff>\n  <baseUrlAdminMessageOff>false</baseUrlAdminMessageOff>\n  <allowRemoteApi>true</allowRemoteApi>\n  <allowRemoteApiAnonymous>false</allowRemoteApiAnonymous>\n  <gzippingResponse>false</gzippingResponse>\n  <disableLogo>false</disableLogo>\n  <sharedMode>false</sharedMode>\n  <captchaSettings>\n    <enableCaptcha>false</enableCaptcha>\n    <captchaGroups class="list"/>\n    <exclude>registered</exclude>\n  </captchaSettings>\n  <customHtmlSettings>\n    <beforeHeadEnd></beforeHeadEnd>\n    <afterBodyStart></afterBodyStart>\n    <beforeBodyEnd></beforeBodyEnd>\n  </customHtmlSettings>\n  <colourSchemesSettings>\n    <colourSchemeType>custom</colourSchemeType>\n  </colourSchemesSettings>\n  <attachmentMaxSize>10485760</attachmentMaxSize>\n  <draftSaveInterval>30000</draftSaveInterval>\n  <maxAttachmentsInUI>5</maxAttachmentsInUI>\n  <siteTitle>Confluence</siteTitle>\n  <emailAddressVisibility>email.address.public</emailAddressVisibility>\n  <defaultEncoding>UTF-8</defaultEncoding>\n  <maxThumbHeight>200</maxThumbHeight>\n  <maxThumbWidth>200</maxThumbWidth>\n  <backupAttachmentsDaily>true</backupAttachmentsDaily>\n  <nofollowExternalLinks>true</nofollowExternalLinks>\n  <indexingLanguage>english</indexingLanguage>\n  <globalDefaultLocale>en_GB</globalDefaultLocale>\n  <dailyBackupFilePrefix>daily-backup-</dailyBackupFilePrefix>\n  <dailyBackupDateFormatPattern>yyyy_MM_dd</dailyBackupDateFormatPattern>\n  <supportRequestEmail>confluence-autosupportrequests@atlassian.com</supportRequestEmail>\n  <enableWysiwyg>true</enableWysiwyg>\n  <useWysiwygByDefault>true</useWysiwygByDefault>\n  <numberOfBreadcrumbAncestors>1</numberOfBreadcrumbAncestors>\n  <defaultSpaceHomepageTitle>Home</defaultSpaceHomepageTitle>\n  <defaultSpaceHomepageContent>This is the home page for the {0} space.</defaultSpaceHomepageContent>\n  <defaultPersonalSpaceHomepageContent>This is the home page for the {0} space.</defaultPersonalSpaceHomepageContent>\n  <baseUrl>http://localhost:8080</baseUrl>\n  <attachmentDataStore>file.system.based.attachments.storage</attachmentDataStore>\n  <displayLinkIcons>false</displayLinkIcons>\n  <confluenceHttpParameters>\n    <connectionTimeout>10000</connectionTimeout>\n    <socketTimeout>10000</socketTimeout>\n    <enabled>true</enabled>\n  </confluenceHttpParameters>\n</settings>
2	_GLOBAL	confluence.server.id	<string>AB31-P0T9-ZU1M-00CN</string>
\.


--
-- Data for Name: bodycontent; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY bodycontent (bodycontentid, body, contentid) FROM stdin;
\.


--
-- Data for Name: clustersafety; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY clustersafety (clustersafetyid, safetynumber) FROM stdin;
229377	-1187869690
\.


--
-- Data for Name: confancestors; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY confancestors (descendentid, ancestorid, ancestorposition) FROM stdin;
\.


--
-- Data for Name: confversion; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY confversion (confversionid, buildnumber, installdate, versiontag, creationdate, lastmoddate) FROM stdin;
\.


--
-- Data for Name: content; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY content (contentid, contenttype, title, version, creator, creationdate, lastmodifier, lastmoddate, versioncomment, prevver, content_status, spaceid, child_position, parentid, messageid, draftpageid, draftspacekey, drafttype, draftpageversion, pageid, parentcommentid, username) FROM stdin;
131073	USERINFO	\N	1	\N	2008-07-08 12:22:43.801	\N	2008-07-08 12:22:43.801		\N	current	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	admin
\.


--
-- Data for Name: content_label; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY content_label (id, labelid, contentid, spacekey, "owner", creationdate, lastmoddate) FROM stdin;
\.


--
-- Data for Name: content_perm; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY content_perm (id, cp_type, username, groupname, cps_id, creator, creationdate, lastmodifier, lastmoddate) FROM stdin;
\.


--
-- Data for Name: content_perm_set; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY content_perm_set (id, cont_perm_type, content_id, creationdate, lastmoddate) FROM stdin;
\.


--
-- Data for Name: contentlock; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY contentlock (contentlockid, title, groupname, expirydate, content, creator, commentstr, creationdate, lastmodifier, lastmoddate) FROM stdin;
\.


--
-- Data for Name: decorator; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY decorator (decoratorid, spacekey, decoratorname, body, lastmoddate) FROM stdin;
\.


--
-- Data for Name: external_entities; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY external_entities (id, name, "type") FROM stdin;
\.


--
-- Data for Name: external_members; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY external_members (extentityid, groupid) FROM stdin;
\.


--
-- Data for Name: extrnlnks; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY extrnlnks (linkid, contenttype, viewcount, url, contentid, creator, creationdate, lastmodifier, lastmoddate) FROM stdin;
\.


--
-- Data for Name: groups; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY groups (id, groupname) FROM stdin;
32769	confluence-administrators
32770	confluence-users
\.


--
-- Data for Name: hibernate_unique_key; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY hibernate_unique_key (next_hi) FROM stdin;
8
\.


--
-- Data for Name: indexqueueentries; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY indexqueueentries (entryid, creationdate, "type", handle) FROM stdin;
163841	2008-07-08 12:22:43.807	1	com.atlassian.confluence.user.PersonalInformation-131073
\.


--
-- Data for Name: keystore; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY keystore (keyid, alias, "type", algorithm, keyspec) FROM stdin;
196609	confluence:13948528	public	RSA	MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAu+JhbWm20SPoQq6PXAQ/EglUEk8BUQa+zFfuW8ibAzjOtjdzg+XA98wQ4CGUEXJ+UmK4BGFu7kTJBIXCRqDF4SuxccqglbqwKWQj/BnL1Zj7Q/n8e9lfyr6KRoPjI/Zik+rLefLrszbRns/YxNrIPIc80Fchc8LBGtMUFCumszbldJzfchVgLDGzxyJTQfPJysy/LM4YVzcPFrPh3RgVP58nM+h/ACjjglQUPDqVaKlijToTfHkofPTmQkNufAtxz+vpYZVrVc2z23LEQ/3guEUxb4lG2CH363Q+wPmhM2mHW6JTIjAbBceU6yF2Mm0h67gA8OElzEyPZYusbuicPwIDAQAB
196610	confluence:13948528	private	RSA	MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQC74mFtabbRI+hCro9cBD8SCVQSTwFRBr7MV+5byJsDOM62N3OD5cD3zBDgIZQRcn5SYrgEYW7uRMkEhcJGoMXhK7FxyqCVurApZCP8GcvVmPtD+fx72V/KvopGg+Mj9mKT6st58uuzNtGez9jE2sg8hzzQVyFzwsEa0xQUK6azNuV0nN9yFWAsMbPHIlNB88nKzL8szhhXNw8Ws+HdGBU/nycz6H8AKOOCVBQ8OpVoqWKNOhN8eSh89OZCQ258C3HP6+lhlWtVzbPbcsRD/eC4RTFviUbYIffrdD7A+aEzaYdbolMiMBsFx5TrIXYybSHruADw4SXMTI9li6xu6Jw/AgMBAAECggEBAJk1t4EDTaMqBsIpmpnMlKnelYIAjvBF8dysb6DE6zMrZdVNTpNmDX+EFtbOSvIXTU9dVPWthkoiKVHYyV3SyMofWSmTtHOksvZtxLJVTtS1VWBPQEa2Mdkgm514+wZeanB4bMjbAL05nKJGl1uflN1W4o56HrtJOzLmoV75YYyNdRaufRyaBBe0ffj+FdBHftHtJagtsu9cKSIjoa8Jh1aN55whEuu3PNDTe5NFIWWMN2k8ZI74jrJdSEJUWhhZvhrzgHSvai+5zkdXRjRxtqqFvZ+OUqJtwhv2eeP8LWG+LhBxuu+jIj+keJE2yRUg2yygJhYH6q9c61c2ymkehLECgYEA+AWmMLTd8ftNiq8EhX4n9EJzG7SUYlpEllU3tdKYHSe49sSinzzjA3JnyFBEKs3MMqH3Lg4hRR6CloMfNuNjFxtja+oGtwSaYNdbjvhgE2WfrpDQWwLRB5rYzIrkgoftLe+BSqzm+qs85PqLGmwXwOnwvghJbIRpp8erCiiL3WsCgYEAwe2GFY02gePI5WHAcClrcIwsRHQjPUTaXWbvr0pWoKbkNv9Dp+yJCpvapbww35HcNwfDoU6qNv4WDt6XXOivJQqnazI27IBRPAlXyGU5tZ6eJxemWnSZboAuWppNtvicVuZUO+1xldXbtVg93LgFQ/iTI+BkStS2Mui4NMBRPX0CgYAn5Fi3qs+r9RyiusXCZuksO2fiQ+g97YDsoSZFw2qd/d6dKkFx1Uw6KLOSn35nWBSI7E4ihTlKsb6VUN+7Z1VvyQLzv392/nGKM/lRBJgHZqgJXtd0W/6c94X5WDmq2QwIAGbOSQMZvGMd/UJUbKBhcf87wX91ydJonw/eoWjlowKBgQCXw6KjSxfVHsYhfRZ0sHV8ZrZd++V4FWIuplf8/lg88V64C5yO1fWJb970xQoabLPB/TmEC2P6FW59xIUAGLi4bFYI9gs1mlX4ffdMxKsdDz0FquRs9cL9TyL3lLos7vKqryZMn828TNjcWmpPSVQVlXrRINJcHYtY2/cMkVUCoQKBgQDFzDOZi53SqUPpjWRukERpXwia121fifzV7vzDZyFkwTKvTbMiW4HVgOgX1junOh6SsIohd8YYVc2gjfL5Q8KeUgg+6r/ebaxdlXzx1FPowcxVGrfdTd+BhXTjrRpasEB1ppqV1rTZsR8m1pxYJQAc0Gmk1CDtEaLYSXE+HW8D9A==
\.


--
-- Data for Name: label; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY label (labelid, name, "owner", namespace, creationdate, lastmoddate) FROM stdin;
\.


--
-- Data for Name: links; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY links (linkid, destpagetitle, destspacekey, contentid, creator, creationdate, lastmodifier, lastmoddate) FROM stdin;
\.


--
-- Data for Name: local_members; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY local_members (userid, groupid) FROM stdin;
98305	32769
98305	32770
\.


--
-- Data for Name: notifications; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY notifications (notificationid, pageid, spaceid, username, creator, creationdate, lastmodifier, lastmoddate) FROM stdin;
\.


--
-- Data for Name: os_group; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY os_group (id, groupname) FROM stdin;
\.


--
-- Data for Name: os_propertyentry; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY os_propertyentry (entity_name, entity_id, entity_key, key_type, boolean_val, double_val, string_val, text_val, long_val, int_val, date_val) FROM stdin;
\.


--
-- Data for Name: os_user; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY os_user (id, username, passwd) FROM stdin;
\.


--
-- Data for Name: os_user_group; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY os_user_group (group_id, user_id) FROM stdin;
\.


--
-- Data for Name: pagetemplates; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY pagetemplates (templateid, templatename, templatedesc, labels, content, spaceid, prevver, version, creator, creationdate, lastmodifier, lastmoddate) FROM stdin;
\.


--
-- Data for Name: plugindata; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY plugindata (plugindataid, pluginkey, filename, lastmoddate, data) FROM stdin;
\.


--
-- Data for Name: spacegroups; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY spacegroups (spacegroupid, spacegroupname, spacegroupkey, licensekey, creator, creationdate, lastmodifier, lastmoddate) FROM stdin;
\.


--
-- Data for Name: spacepermissions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY spacepermissions (permid, spaceid, permtype, permgroupname, permusername, creator, creationdate, lastmodifier, lastmoddate) FROM stdin;
65537	\N	SYSTEMADMINISTRATOR	confluence-administrators	\N	\N	2008-07-08 12:22:43.767	\N	2008-07-08 12:22:43.767
65538	\N	USECONFLUENCE	confluence-administrators	\N	\N	2008-07-08 12:22:43.773	\N	2008-07-08 12:22:43.773
65539	\N	ADMINISTRATECONFLUENCE	confluence-administrators	\N	\N	2008-07-08 12:22:43.773	\N	2008-07-08 12:22:43.773
65540	\N	PERSONALSPACE	confluence-administrators	\N	\N	2008-07-08 12:22:43.773	\N	2008-07-08 12:22:43.773
65541	\N	USECONFLUENCE	confluence-users	\N	\N	2008-07-08 12:22:43.773	\N	2008-07-08 12:22:43.773
65542	\N	PERSONALSPACE	confluence-users	\N	\N	2008-07-08 12:22:43.773	\N	2008-07-08 12:22:43.773
65543	\N	CREATESPACE	confluence-administrators	\N	\N	2008-07-08 12:22:43.773	\N	2008-07-08 12:22:43.773
\.


--
-- Data for Name: spaces; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY spaces (spaceid, spacename, spacekey, spacedescid, homepage, creator, creationdate, lastmodifier, lastmoddate, spacetype, spacegroupid) FROM stdin;
\.


--
-- Data for Name: trackbacklinks; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY trackbacklinks (linkid, contenttype, viewcount, url, title, blogname, excerpt, contentid, creator, creationdate, lastmodifier, lastmoddate) FROM stdin;
\.


--
-- Data for Name: trustedapp; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY trustedapp (trustedappid, name, timeout, public_key_id) FROM stdin;
\.


--
-- Data for Name: trustedapprestriction; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY trustedapprestriction (trustedapprestrictionid, "type", restriction, trustedappid) FROM stdin;
\.


--
-- Data for Name: users; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY users (id, name, "password", email, created, fullname) FROM stdin;
98305	admin	x61Ey612Kl2gpFL56FT9weDnpSo4AV8j8+qx2AuTHdRyY036xxzTTrw10Wq3+4qQyB+XURPWx1ONxp3Y3pB37A==		2008-07-08 12:22:43.774	admin
\.


--
-- Name: attachmentdata_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY attachmentdata
    ADD CONSTRAINT attachmentdata_pkey PRIMARY KEY (attachmentdataid);


--
-- Name: attachments_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY attachments
    ADD CONSTRAINT attachments_pkey PRIMARY KEY (attachmentid);


--
-- Name: bandana_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY bandana
    ADD CONSTRAINT bandana_pkey PRIMARY KEY (bandanaid);


--
-- Name: bodycontent_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY bodycontent
    ADD CONSTRAINT bodycontent_pkey PRIMARY KEY (bodycontentid);


--
-- Name: clustersafety_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY clustersafety
    ADD CONSTRAINT clustersafety_pkey PRIMARY KEY (clustersafetyid);


--
-- Name: confancestors_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY confancestors
    ADD CONSTRAINT confancestors_pkey PRIMARY KEY (descendentid, ancestorposition);


--
-- Name: confversion_buildnumber_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY confversion
    ADD CONSTRAINT confversion_buildnumber_key UNIQUE (buildnumber);


--
-- Name: confversion_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY confversion
    ADD CONSTRAINT confversion_pkey PRIMARY KEY (confversionid);


--
-- Name: content_label_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY content_label
    ADD CONSTRAINT content_label_pkey PRIMARY KEY (id);


--
-- Name: content_perm_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY content_perm
    ADD CONSTRAINT content_perm_pkey PRIMARY KEY (id);


--
-- Name: content_perm_set_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY content_perm_set
    ADD CONSTRAINT content_perm_set_pkey PRIMARY KEY (id);


--
-- Name: content_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY content
    ADD CONSTRAINT content_pkey PRIMARY KEY (contentid);


--
-- Name: contentlock_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY contentlock
    ADD CONSTRAINT contentlock_pkey PRIMARY KEY (contentlockid);


--
-- Name: decorator_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY decorator
    ADD CONSTRAINT decorator_pkey PRIMARY KEY (decoratorid);


--
-- Name: external_entities_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY external_entities
    ADD CONSTRAINT external_entities_pkey PRIMARY KEY (id);


--
-- Name: external_members_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY external_members
    ADD CONSTRAINT external_members_pkey PRIMARY KEY (groupid, extentityid);


--
-- Name: extrnlnks_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY extrnlnks
    ADD CONSTRAINT extrnlnks_pkey PRIMARY KEY (linkid);


--
-- Name: groups_groupname_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY groups
    ADD CONSTRAINT groups_groupname_key UNIQUE (groupname);


--
-- Name: groups_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY groups
    ADD CONSTRAINT groups_pkey PRIMARY KEY (id);


--
-- Name: indexqueueentries_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY indexqueueentries
    ADD CONSTRAINT indexqueueentries_pkey PRIMARY KEY (entryid);


--
-- Name: keystore_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY keystore
    ADD CONSTRAINT keystore_pkey PRIMARY KEY (keyid);


--
-- Name: label_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY label
    ADD CONSTRAINT label_pkey PRIMARY KEY (labelid);


--
-- Name: links_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY links
    ADD CONSTRAINT links_pkey PRIMARY KEY (linkid);


--
-- Name: local_members_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY local_members
    ADD CONSTRAINT local_members_pkey PRIMARY KEY (groupid, userid);


--
-- Name: notifications_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY notifications
    ADD CONSTRAINT notifications_pkey PRIMARY KEY (notificationid);


--
-- Name: os_group_groupname_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY os_group
    ADD CONSTRAINT os_group_groupname_key UNIQUE (groupname);


--
-- Name: os_group_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY os_group
    ADD CONSTRAINT os_group_pkey PRIMARY KEY (id);


--
-- Name: os_propertyentry_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY os_propertyentry
    ADD CONSTRAINT os_propertyentry_pkey PRIMARY KEY (entity_name, entity_id, entity_key);


--
-- Name: os_user_group_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY os_user_group
    ADD CONSTRAINT os_user_group_pkey PRIMARY KEY (user_id, group_id);


--
-- Name: os_user_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY os_user
    ADD CONSTRAINT os_user_pkey PRIMARY KEY (id);


--
-- Name: os_user_username_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY os_user
    ADD CONSTRAINT os_user_username_key UNIQUE (username);


--
-- Name: pagetemplates_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY pagetemplates
    ADD CONSTRAINT pagetemplates_pkey PRIMARY KEY (templateid);


--
-- Name: plugindata_filename_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY plugindata
    ADD CONSTRAINT plugindata_filename_key UNIQUE (filename);


--
-- Name: plugindata_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY plugindata
    ADD CONSTRAINT plugindata_pkey PRIMARY KEY (plugindataid);


--
-- Name: plugindata_pluginkey_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY plugindata
    ADD CONSTRAINT plugindata_pluginkey_key UNIQUE (pluginkey);


--
-- Name: spacegroups_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY spacegroups
    ADD CONSTRAINT spacegroups_pkey PRIMARY KEY (spacegroupid);


--
-- Name: spacegroups_spacegroupkey_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY spacegroups
    ADD CONSTRAINT spacegroups_spacegroupkey_key UNIQUE (spacegroupkey);


--
-- Name: spacepermissions_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY spacepermissions
    ADD CONSTRAINT spacepermissions_pkey PRIMARY KEY (permid);


--
-- Name: spaces_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY spaces
    ADD CONSTRAINT spaces_pkey PRIMARY KEY (spaceid);


--
-- Name: spaces_spacekey_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY spaces
    ADD CONSTRAINT spaces_spacekey_key UNIQUE (spacekey);


--
-- Name: trackbacklinks_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY trackbacklinks
    ADD CONSTRAINT trackbacklinks_pkey PRIMARY KEY (linkid);


--
-- Name: trustedapp_name_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY trustedapp
    ADD CONSTRAINT trustedapp_name_key UNIQUE (name);


--
-- Name: trustedapp_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY trustedapp
    ADD CONSTRAINT trustedapp_pkey PRIMARY KEY (trustedappid);


--
-- Name: trustedapp_public_key_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY trustedapp
    ADD CONSTRAINT trustedapp_public_key_id_key UNIQUE (public_key_id);


--
-- Name: trustedapprestriction_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY trustedapprestriction
    ADD CONSTRAINT trustedapprestriction_pkey PRIMARY KEY (trustedapprestrictionid);


--
-- Name: users_name_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY users
    ADD CONSTRAINT users_name_key UNIQUE (name);


--
-- Name: users_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY users
    ADD CONSTRAINT users_pkey PRIMARY KEY (id);


--
-- Name: att_pageid_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX att_pageid_idx ON attachments USING btree (pageid);


--
-- Name: att_prevver_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX att_prevver_idx ON attachments USING btree (prevver);


--
-- Name: attch_data_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX attch_data_idx ON attachmentdata USING btree (attachmentid);


--
-- Name: band_context_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX band_context_idx ON bandana USING btree (bandanacontext);


--
-- Name: band_key_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX band_key_idx ON bandana USING btree (bandanakey);


--
-- Name: body_content_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX body_content_idx ON bodycontent USING btree (contentid);


--
-- Name: c_draftpageid_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX c_draftpageid_idx ON content USING btree (draftpageid);


--
-- Name: c_drafttype_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX c_drafttype_idx ON content USING btree (drafttype);


--
-- Name: c_messageid_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX c_messageid_idx ON content USING btree (messageid);


--
-- Name: c_parentcommid_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX c_parentcommid_idx ON content USING btree (parentcommentid);


--
-- Name: c_parentid_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX c_parentid_idx ON content USING btree (parentid);


--
-- Name: c_prevver_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX c_prevver_idx ON content USING btree (prevver);


--
-- Name: c_spaceid_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX c_spaceid_idx ON content USING btree (spaceid);


--
-- Name: c_title_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX c_title_idx ON content USING btree (title);


--
-- Name: c_username_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX c_username_idx ON content USING btree (username);


--
-- Name: cl_content_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX cl_content_idx ON contentlock USING btree (content);


--
-- Name: cl_contentid_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX cl_contentid_idx ON content_label USING btree (contentid);


--
-- Name: cl_labelid_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX cl_labelid_idx ON content_label USING btree (labelid);


--
-- Name: cl_lastmoddate_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX cl_lastmoddate_idx ON content_label USING btree (lastmoddate);


--
-- Name: cl_spacekey_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX cl_spacekey_idx ON content_label USING btree (spacekey);


--
-- Name: cl_title_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX cl_title_idx ON contentlock USING btree (title);


--
-- Name: cp_gn_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX cp_gn_idx ON content_perm USING btree (groupname);


--
-- Name: cp_os_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX cp_os_idx ON content_perm USING btree (cps_id);


--
-- Name: cp_un_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX cp_un_idx ON content_perm USING btree (username);


--
-- Name: cps_content_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX cps_content_idx ON content_perm_set USING btree (content_id);


--
-- Name: dec_key_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX dec_key_idx ON decorator USING btree (spacekey);


--
-- Name: dec_name_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX dec_name_idx ON decorator USING btree (decoratorname);


--
-- Name: el_contentid_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX el_contentid_idx ON extrnlnks USING btree (contentid);


--
-- Name: l_contentid_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX l_contentid_idx ON links USING btree (contentid);


--
-- Name: l_destspacekey_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX l_destspacekey_idx ON links USING btree (destspacekey);


--
-- Name: l_name_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX l_name_idx ON label USING btree (name);


--
-- Name: l_namespace_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX l_namespace_idx ON label USING btree (namespace);


--
-- Name: l_owner_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX l_owner_idx ON label USING btree ("owner");


--
-- Name: n_pageid_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX n_pageid_idx ON notifications USING btree (pageid);


--
-- Name: n_spaceid_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX n_spaceid_idx ON notifications USING btree (spaceid);


--
-- Name: pt_prevver_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX pt_prevver_idx ON pagetemplates USING btree (prevver);


--
-- Name: pt_spaceid_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX pt_spaceid_idx ON pagetemplates USING btree (spaceid);


--
-- Name: s_homepage_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX s_homepage_idx ON spaces USING btree (homepage);


--
-- Name: s_spacedescid_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX s_spacedescid_idx ON spaces USING btree (spacedescid);


--
-- Name: s_spacegroupid_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX s_spacegroupid_idx ON spaces USING btree (spacegroupid);


--
-- Name: sp_permtype_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX sp_permtype_idx ON spacepermissions USING btree (permtype);


--
-- Name: sp_pgname_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX sp_pgname_idx ON spacepermissions USING btree (permgroupname);


--
-- Name: sp_puname_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX sp_puname_idx ON spacepermissions USING btree (permusername);


--
-- Name: sp_spaceid_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX sp_spaceid_idx ON spacepermissions USING btree (spaceid);


--
-- Name: tbl_contentid_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX tbl_contentid_idx ON trackbacklinks USING btree (contentid);


--
-- Name: fk45157998dd41734; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY links
    ADD CONSTRAINT fk45157998dd41734 FOREIGN KEY (contentid) REFERENCES content(contentid);


--
-- Name: fk54475f9017d4a070; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY attachments
    ADD CONSTRAINT fk54475f9017d4a070 FOREIGN KEY (prevver) REFERENCES attachments(attachmentid);


--
-- Name: fk54475f908c38fbea; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY attachments
    ADD CONSTRAINT fk54475f908c38fbea FOREIGN KEY (pageid) REFERENCES content(contentid);


--
-- Name: fk594acc88c38fbea; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY notifications
    ADD CONSTRAINT fk594acc88c38fbea FOREIGN KEY (pageid) REFERENCES content(contentid);


--
-- Name: fk594acc8b2dc6081; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY notifications
    ADD CONSTRAINT fk594acc8b2dc6081 FOREIGN KEY (spaceid) REFERENCES spaces(spaceid);


--
-- Name: fk6382c05917d4a070; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY content
    ADD CONSTRAINT fk6382c05917d4a070 FOREIGN KEY (prevver) REFERENCES content(contentid);


--
-- Name: fk6382c05974b18345; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY content
    ADD CONSTRAINT fk6382c05974b18345 FOREIGN KEY (parentid) REFERENCES content(contentid);


--
-- Name: fk6382c0598c38fbea; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY content
    ADD CONSTRAINT fk6382c0598c38fbea FOREIGN KEY (pageid) REFERENCES content(contentid);


--
-- Name: fk6382c059b2dc6081; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY content
    ADD CONSTRAINT fk6382c059b2dc6081 FOREIGN KEY (spaceid) REFERENCES spaces(spaceid);


--
-- Name: fk6382c059b97e9230; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY content
    ADD CONSTRAINT fk6382c059b97e9230 FOREIGN KEY (parentcommentid) REFERENCES content(contentid);


--
-- Name: fk692ca9046382c059; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY contentlock
    ADD CONSTRAINT fk692ca9046382c059 FOREIGN KEY (content) REFERENCES content(contentid);


--
-- Name: fk6b8fb445117d5fda; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY local_members
    ADD CONSTRAINT fk6b8fb445117d5fda FOREIGN KEY (groupid) REFERENCES groups(id);


--
-- Name: fk6b8fb445ce2b3226; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY local_members
    ADD CONSTRAINT fk6b8fb445ce2b3226 FOREIGN KEY (userid) REFERENCES users(id);


--
-- Name: fk9228242d11b7bfee; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY spaces
    ADD CONSTRAINT fk9228242d11b7bfee FOREIGN KEY (homepage) REFERENCES content(contentid);


--
-- Name: fk9228242d16994414; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY spaces
    ADD CONSTRAINT fk9228242d16994414 FOREIGN KEY (spacegroupid) REFERENCES spacegroups(spacegroupid);


--
-- Name: fk9228242d2c72d3d2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY spaces
    ADD CONSTRAINT fk9228242d2c72d3d2 FOREIGN KEY (spacedescid) REFERENCES content(contentid);


--
-- Name: fk932472461e2e76db; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY os_user_group
    ADD CONSTRAINT fk932472461e2e76db FOREIGN KEY (group_id) REFERENCES os_group(id);


--
-- Name: fk93247246f73aee0f; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY os_user_group
    ADD CONSTRAINT fk93247246f73aee0f FOREIGN KEY (user_id) REFERENCES os_user(id);


--
-- Name: fk9494e23c37e35a2e; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY confancestors
    ADD CONSTRAINT fk9494e23c37e35a2e FOREIGN KEY (ancestorid) REFERENCES content(contentid);


--
-- Name: fk9494e23cc45e94dc; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY confancestors
    ADD CONSTRAINT fk9494e23cc45e94dc FOREIGN KEY (descendentid) REFERENCES content(contentid);


--
-- Name: fk97c10fe78dd41734; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY extrnlnks
    ADD CONSTRAINT fk97c10fe78dd41734 FOREIGN KEY (contentid) REFERENCES content(contentid);


--
-- Name: fk9dc3e34d34a4917e; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY attachmentdata
    ADD CONSTRAINT fk9dc3e34d34a4917e FOREIGN KEY (attachmentid) REFERENCES attachments(attachmentid);


--
-- Name: fka898d4778dd41734; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY bodycontent
    ADD CONSTRAINT fka898d4778dd41734 FOREIGN KEY (contentid) REFERENCES content(contentid);


--
-- Name: fkbc7ce96a17d4a070; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY pagetemplates
    ADD CONSTRAINT fkbc7ce96a17d4a070 FOREIGN KEY (prevver) REFERENCES pagetemplates(templateid);


--
-- Name: fkbc7ce96ab2dc6081; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY pagetemplates
    ADD CONSTRAINT fkbc7ce96ab2dc6081 FOREIGN KEY (spaceid) REFERENCES spaces(spaceid);


--
-- Name: fkbd74b31676e33274; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY content_perm
    ADD CONSTRAINT fkbd74b31676e33274 FOREIGN KEY (cps_id) REFERENCES content_perm_set(id);


--
-- Name: fkbf45a7992caf22c1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY content_perm_set
    ADD CONSTRAINT fkbf45a7992caf22c1 FOREIGN KEY (content_id) REFERENCES content(contentid);


--
-- Name: fkd33f23beb2dc6081; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY spacepermissions
    ADD CONSTRAINT fkd33f23beb2dc6081 FOREIGN KEY (spaceid) REFERENCES spaces(spaceid);


--
-- Name: fkd8c8d8a5117d5fda; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY external_members
    ADD CONSTRAINT fkd8c8d8a5117d5fda FOREIGN KEY (groupid) REFERENCES groups(id);


--
-- Name: fkd8c8d8a5f25e5d5f; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY external_members
    ADD CONSTRAINT fkd8c8d8a5f25e5d5f FOREIGN KEY (extentityid) REFERENCES external_entities(id);


--
-- Name: fkddb119ca9c85adb1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY trustedapp
    ADD CONSTRAINT fkddb119ca9c85adb1 FOREIGN KEY (public_key_id) REFERENCES keystore(keyid);


--
-- Name: fke8496ba235d1d865; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY trustedapprestriction
    ADD CONSTRAINT fke8496ba235d1d865 FOREIGN KEY (trustedappid) REFERENCES trustedapp(trustedappid);


--
-- Name: fkf0e7436e27072aef; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY content_label
    ADD CONSTRAINT fkf0e7436e27072aef FOREIGN KEY (labelid) REFERENCES label(labelid);


--
-- Name: fkf0e7436e8dd41734; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY content_label
    ADD CONSTRAINT fkf0e7436e8dd41734 FOREIGN KEY (contentid) REFERENCES content(contentid);


--
-- Name: fkf6977a478dd41734; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY trackbacklinks
    ADD CONSTRAINT fkf6977a478dd41734 FOREIGN KEY (contentid) REFERENCES content(contentid);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres81
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres81;
GRANT ALL ON SCHEMA public TO postgres81;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

