# ruby scripts to process the Atlassian CAC access logs
# Creator: Nicky Cheng
# K.J. Ross & Associates Pty. Ltd.
#filename: Atlassian-processDailyLog-hourly.rb
# Description: The script takes the outputs of Atlassian-processDailyLog.rb and generate the hourly stats of each defined user operation of each day.
#		It outputs a number of CSV files for futher analysis


dirName = (ARGV[0]||'admin')
logDir = Dir.entries(Dir.pwd + "/" +dirName+"/") 
filenameRegexp = Regexp.new('confluence.atlassian.com-access.log')

hours = {1=>0, 2=>0, 3=>0, 4=>0, 5=>0, 6=>0, 7=>0, 8=>0, 9=>0, 10=>0, 11=>0, 12=>0, 13=>0, 14=>0, 15=>0, 16=>0, 17=>0, 18=>0, 19=>0, 20=>0, 21=>0, 22=>0, 23=>0, 24=>0}


summaryOutFile = File.open( Dir.pwd+"/"+dirName+".csv", "a")
for filename in logDir 
	if filenameRegexp.match(filename)
		inFileLines = IO.readlines(Dir.pwd + "/"+dirName+"/" + filename)
		
		for i in 0..inFileLines.length-1
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]00[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[24] = hours[24]+1
			end
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]01[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[1] = hours[1]+1
			end
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]02[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[2] = hours[2]+1
			end
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]03[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[3] = hours[3]+1
			end
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]04[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[4] = hours[4]+1
			end
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]05[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[5] = hours[5]+1
			end
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]06[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[6] = hours[6]+1
			end
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]07[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[7] = hours[7]+1
			end
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]08[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[8] = hours[8]+1
			end
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]09[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[9] = hours[9]+1
			end
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]10[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[10] = hours[10]+1
			end
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]11[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[11] = hours[11]+1
			end
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]12[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[12] = hours[12]+1
			end
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]13[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[13] = hours[13]+1
			end
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]14[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[14] = hours[14]+1
			end
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]15[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[15] = hours[15]+1
			end
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]16[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[16] = hours[16]+1
			end
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]17[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[17] = hours[17]+1
			end
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]18[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[18] = hours[18]+1
			end
			
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]19[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[19] = hours[19]+1
			end
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]20[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[20] = hours[20]+1
			end
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]21[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[21] = hours[21]+1
			end
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]22[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[22] = hours[22]+1
			end
			if inFileLines[i] =~ /\[[0-9][0-9]\/[A-Z][a-z][a-z]\/[0-9][0-9][0-9][0-9][:]23[:][0-9][0-9][:][0-9][0-9] [-][0-9][0-9][0-9][0-9]\]/
				hours[23] = hours[23]+1
			end
		end
		temp = filename.to_s + "," + hours[24].to_s
		temp = temp + "," + hours[1].to_s 
		temp = temp + "," + hours[2].to_s 
		temp = temp + "," + hours[3].to_s 
		temp = temp + "," + hours[4].to_s 
		temp = temp + "," + hours[5].to_s 
		temp = temp + "," + hours[6].to_s 
		temp = temp + "," + hours[7].to_s
		temp = temp + "," + hours[8].to_s 
		temp = temp + "," + hours[9].to_s 
		temp = temp + "," + hours[10].to_s 
		temp = temp + "," + hours[11].to_s 
		temp = temp + "," + hours[12].to_s 
		temp = temp + "," + hours[13].to_s 
		temp = temp + "," + hours[14].to_s 
		temp = temp + "," + hours[15].to_s
		temp = temp + "," + hours[16].to_s
		temp = temp + "," + hours[17].to_s
		temp = temp + "," + hours[18].to_s
		temp = temp + "," + hours[19].to_s
		temp = temp + "," + hours[20].to_s
		temp = temp + "," + hours[21].to_s
		temp = temp + "," + hours[22].to_s
		temp = temp + "," + hours[23].to_s
		summaryOutFile.puts temp
		
		hours[24] = 0
		hours[1]=0
		hours[2]=0
		hours[3]=0
		hours[4]=0
		hours[5]=0
		hours[6]=0
		hours[7]=0
		hours[8]=0
		hours[9]=0
		hours[10]=0
		hours[11]=0
		hours[12]=0
		hours[13]=0
		hours[14]=0
		hours[15]=0
		hours[16]=0
		hours[17]=0
		hours[18]=0
		hours[19]=0
		hours[20]=0
		hours[21]=0
		hours[22]=0
		hours[23]=0
	end
end
summaryOutFile.close