# ruby scripts to process the Atlassian CAC access logs
# Creator: Nicky Cheng
# K.J. Ross & Associates Pty. Ltd.
#filename: Atlassian-processDailyLog.rb
# Description: Process the CAC daily log files in a directory called logs and output a csv file and files of each action.
#		The CSV contains the daily summary usage. The other files created in different directory are used as input for
#		further processing


logDir = Dir.entries(Dir.pwd + "/logs/") 
filenameRegexp = Regexp.new('confluence.atlassian.com-access.log')

searchPost = []
#searchGet = []
rss =[]
create =[]
edit =[]
read =[]
comment =[]
admin = []

searchPostCount = 0
#searchGetCount = 0
rssCount = 0
createCount = 0
editCount = 0
readCount = 0
commentCount = 0
adminCount = 0

summaryOutFile = File.open( Dir.pwd+"/summary.csv", "a")
Dir.mkdir(Dir.pwd+"/search/")
Dir.mkdir(Dir.pwd+"/rss/")
Dir.mkdir(Dir.pwd+"/create/")
Dir.mkdir(Dir.pwd+"/edit/")
Dir.mkdir(Dir.pwd+"/read/")
Dir.mkdir(Dir.pwd+"/comment/")
Dir.mkdir(Dir.pwd+"/admin/")
for filename in logDir 
	if filenameRegexp.match(filename)
		inFileLines = IO.readlines(Dir.pwd + "/logs/" + filename)
		searchPostOutFile = File.open( Dir.pwd+"/search/search-POST-"+filename, "a")
		#searchGetOutFile = File.open( Dir.pwd+"/search-GET-"+filename, "a")
		rssOutFile = File.open( Dir.pwd+"/rss/rss-"+filename, "a")
		createOutFile = File.open( Dir.pwd+"/create/create-"+filename, "a")
		editOutFile = File.open( Dir.pwd+"/edit/edit-"+filename, "a")
		readOutFile = File.open( Dir.pwd+"/read/read-"+filename, "a")
		commentOutFile = File.open( Dir.pwd+"/comment/comment-"+filename, "a")
		adminOutFile = File.open( Dir.pwd+"/admin/admin-"+filename, "a")
		
		for i in 0..inFileLines.length-1
			if inFileLines[i] =~ /POST.*dosearchsite.action/
				searchPostOutFile.puts inFileLines[i]
				searchPostCount = searchPostCount + 1
			end
			#if inFileLines[i] =~ /GET.*dosearchsite.action/
			#	searchGetOutFile.puts inFileLines[i]
			#	searchGetCount = searchGetCount + 1
			#end
			if inFileLines[i] =~ /createrssfeed.action/
				rssOutFile.puts inFileLines[i]
				rssCount = rssCount + 1
			end
			if inFileLines[i] =~ /(POST|GET) \/pages\/createpage.action/
				createOutFile.puts inFileLines[i]
				createCount = createCount + 1
			end
			if inFileLines[i] =~ /(POST|GET) \/pages\/editpage.action/
				editOutFile.puts inFileLines[i]
				editCount = editCount + 1
			end
			if inFileLines[i] =~ /GET \/display\//
				readOutFile.puts inFileLines[i]
				readCount = readCount + 1
			end
			if inFileLines[i] =~ /(POST|GET) \/pages\/doaddcomment.action/
				commentOutFile.puts inFileLines[i]
				commentCount = commentCount + 1
			end
			if inFileLines[i] =~ /(POST|GET) \/admin\//
				adminOutFile.puts inFileLines[i]
				adminCount = adminCount + 1
			end
		end
		temp = filename.to_s + "," + searchPostCount.to_s
		#temp = temp + "," + searchGetCount.to_s 
		temp = temp + "," + rssCount.to_s 
		temp = temp + "," + createCount.to_s 
		temp = temp + "," + editCount.to_s 
		temp = temp + "," + readCount.to_s 
		temp = temp + "," + commentCount.to_s 
		temp = temp + "," + adminCount.to_s 
		summaryOutFile.puts temp
		
		searchPostCount = 0
		#searchGetCount =0
		rssCount = 0
		createCount = 0
		editCount = 0
		readCount = 0
		commentCount = 0
		adminCount =0 
		
		searchPostOutFile.close
		#searchGetOutFile.close
		rssOutFile.close
		createOutFile.close
		editOutFile.close
		readOutFile.close
		commentOutFile.close
		adminOutFile.close
	end
end
summaryOutFile.close