/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.ipd.api;

import java.util.Objects;

public class MeterTag {
    private final String key;
    private final String value;

    private MeterTag(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public MeterTag getFormattedTag() {
        return MeterTag.of(this.key.replace(" ", "_"), this.value.replace(" ", "_"));
    }

    public static MeterTag of(String key, String value) {
        return new MeterTag(key, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeterTag meterTag = (MeterTag)o;
        return Objects.equals(this.key, meterTag.key) && Objects.equals(this.value, meterTag.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return this.key + "=" + this.value;
    }
}

