/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.ipd.api.meters;

import com.atlassian.diagnostics.ipd.api.MeterKey;
import com.atlassian.diagnostics.ipd.api.meters.IpdMeter;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterConfig;
import java.time.Clock;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ObjectName;

public abstract class AbstractIpdMeter
implements IpdMeter {
    private final MeterConfig meterConfig;
    private boolean closed = false;
    private final AtomicLong lastUpdateMillis = new AtomicLong(0L);
    private final Clock clock;

    protected AbstractIpdMeter(MeterConfig meterConfig) {
        this.meterConfig = meterConfig;
        this.clock = Optional.ofNullable(meterConfig.getProperties().get("customClock")).map(Clock.class::cast).orElse(Clock.systemUTC());
    }

    @Override
    public MeterConfig getConfig() {
        return this.meterConfig;
    }

    @Override
    public MeterKey getMeterKey() {
        return this.meterConfig.getMeterKey();
    }

    @Override
    public ObjectName getObjectName() {
        return this.meterConfig.getObjectName();
    }

    @Override
    public boolean isEnabled() {
        return !this.closed && this.meterConfig.getEnabledCheck().get() != false;
    }

    @Override
    public void hideUntilUpdate() {
        this.unregisterMBean();
    }

    @Override
    public long lastUpdateMillis() {
        return this.lastUpdateMillis.get();
    }

    protected void metricUpdated() {
        this.registerMBean();
        this.lastUpdateMillis.set(this.clock.millis());
        this.meterConfig.getMetricUpdateListener().accept(this);
    }

    protected abstract void registerMBean();

    protected abstract void unregisterMBean();

    @Override
    public void close() {
        this.unregisterMBean();
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

