/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.ipd.api.meters;

import com.atlassian.diagnostics.ipd.api.meters.IpdMeter;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterConfig;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterFactory;
import com.atlassian.diagnostics.ipd.api.meters.custom.IpdCustomMetricRegisterException;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface CustomMeter<T>
extends IpdMeter {
    public static final String TYPE_ID = "custom";

    public static <T> MeterFactory<CustomMeter<T>> noopFactory(MBeanSupplier<T> mBeanSupplier) {
        return new MeterFactory<CustomMeter<T>>(config -> new Noop(mBeanSupplier.createInstance(), (MeterConfig)config), TYPE_ID, TYPE_ID);
    }

    public T getMBeanObject();

    public void update(Consumer<T> var1);

    public static class MBeanSupplier<BEAN_TYPE> {
        private final Class<BEAN_TYPE> beanType;
        private final Supplier<BEAN_TYPE> mBeanSupplier;

        public MBeanSupplier(Class<BEAN_TYPE> beanType, Supplier<BEAN_TYPE> mBeanSupplier) {
            this.beanType = beanType;
            this.mBeanSupplier = mBeanSupplier;
        }

        public MBeanSupplier(Class<BEAN_TYPE> beanType) {
            this(beanType, () -> {
                try {
                    return beanType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new IpdCustomMetricRegisterException(String.format("Couldn't create instance with default constructor for metric of type %s", beanType.getName()), e);
                }
            });
        }

        public Class<BEAN_TYPE> getBeanType() {
            return this.beanType;
        }

        public BEAN_TYPE createInstance() {
            return this.mBeanSupplier.get();
        }
    }

    public static class Noop<T>
    extends IpdMeter.NoopMeter
    implements CustomMeter<T> {
        private final T instance;

        public Noop(T instance, MeterConfig meterConfig) {
            super(meterConfig);
            this.instance = instance;
        }

        @Override
        public T getMBeanObject() {
            return this.instance;
        }

        @Override
        public String getTypeId() {
            return CustomMeter.TYPE_ID;
        }

        @Override
        public void update(Consumer<T> updater) {
            updater.accept(this.instance);
            this.metricUpdated();
        }
    }
}

