/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.ipd.api.meters.config;

import com.atlassian.diagnostics.ipd.api.MeterKey;
import com.atlassian.diagnostics.ipd.api.meters.IpdMeter;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterConfigBuilderImpl;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.management.ObjectName;
import org.slf4j.Logger;

public class MeterConfig {
    private final MeterKey meterKey;
    private final ObjectName objectName;
    private final Map<String, Object> properties;
    private final boolean workInProgress;
    private final boolean logOnUpdate;
    private final boolean intervalLogging;
    private final Logger logger;
    private final Supplier<Boolean> enabledCheck;
    private final Predicate<IpdMeter> loggingCondition;
    private final Consumer<IpdMeter> updateListener;

    public MeterConfig(MeterKey meterKey, MeterConfigBuilderImpl meterConfigBuilder) {
        this.meterKey = meterKey;
        this.objectName = meterConfigBuilder.objectNameFactory.constructObjectName(meterKey);
        this.enabledCheck = () -> meterConfigBuilder.enabledCheck.test(this);
        this.properties = Collections.unmodifiableMap(meterConfigBuilder.properties);
        this.workInProgress = this.properties.getOrDefault("workInProgress", false).equals(true);
        this.logOnUpdate = this.properties.getOrDefault("logOnUpdate", false).equals(true);
        this.intervalLogging = this.properties.getOrDefault("intervalLogging", true).equals(true);
        this.logger = meterConfigBuilder.logger;
        this.loggingCondition = meterConfigBuilder.shouldLog;
        this.updateListener = this.logOnUpdate ? meterConfigBuilder.updateListener : ignored -> {};
    }

    public Supplier<Boolean> getEnabledCheck() {
        return this.enabledCheck;
    }

    public boolean isWorkInProgress() {
        return this.workInProgress;
    }

    public Consumer<IpdMeter> getMetricUpdateListener() {
        return this.updateListener;
    }

    public MeterKey getMeterKey() {
        return this.meterKey;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean isLogOnUpdate() {
        return this.logOnUpdate;
    }

    public boolean isIntervalLoggingEnabled() {
        return this.intervalLogging;
    }

    public Predicate<IpdMeter> getLoggingCondition() {
        return this.loggingCondition;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static class Properties {
        public static final String WORK_IN_PROGRESS = "workInProgress";
        public static final String LOG_ON_UPDATE = "logOnUpdate";
        public static final String INTERVAL_LOGGING = "intervalLogging";
        public static final String CUSTOM_CLOCK = "customClock";

        private Properties() {
        }
    }
}

