/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.ipd.api.meters.custom;

import com.atlassian.diagnostics.ipd.api.meters.AbstractIpdMeter;
import com.atlassian.diagnostics.ipd.api.meters.CustomMeter;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterConfig;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterFactory;
import com.atlassian.diagnostics.ipd.api.meters.custom.IpdCustomMetricRegisterException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.management.MBeanServer;
import javax.management.MXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomMeterImpl<T>
extends AbstractIpdMeter
implements CustomMeter<T> {
    private static final String TYPE_ID = "custom";
    private static final Logger LOG = LoggerFactory.getLogger(CustomMeterImpl.class);
    private static final String SINGLE_MX_BEAN_REQUIRED_EXCEPTION = "IpdCustomMetric requires the Type %s to implement exactly one interface with @MXBean annotation.";
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final Class<?> beanType;
    private final MBeanServer mBeanServer;
    private final AtomicBoolean jmxRegistered = new AtomicBoolean(false);
    private final ObjectWriter objectWriter;
    private final T mBean;
    private final String typeId;

    protected CustomMeterImpl(MeterConfig config, T mBean) {
        this(config, mBean, ManagementFactory.getPlatformMBeanServer());
    }

    protected CustomMeterImpl(MeterConfig config, T mBean, MBeanServer mBeanServer) {
        super(config);
        this.beanType = mBean.getClass();
        this.mBean = mBean;
        this.mBeanServer = mBeanServer;
        Class<?> interfaceType = this.findMBeanInterface(this.beanType);
        this.objectWriter = OBJECT_MAPPER.writerFor(interfaceType);
        this.typeId = CustomMeterImpl.getTypeId(this.beanType);
        if (this.isEnabled()) {
            this.registerMBean();
        }
    }

    private Class<?> findMBeanInterface(Class<?> type) {
        return Arrays.stream(type.getInterfaces()).filter(i -> i.isAnnotationPresent(MXBean.class)).reduce((a, b) -> {
            throw new IpdCustomMetricRegisterException(String.format(SINGLE_MX_BEAN_REQUIRED_EXCEPTION, type.getName()));
        }).orElseThrow(() -> new IpdCustomMetricRegisterException(String.format(SINGLE_MX_BEAN_REQUIRED_EXCEPTION, type.getName())));
    }

    @Override
    public T getMBeanObject() {
        return this.mBean;
    }

    @Override
    public Map<String, Object> getAttributes(boolean extraAttributes) {
        try {
            String attributes = this.objectWriter.writeValueAsString(this.mBean);
            return (Map)OBJECT_MAPPER.readValue(attributes, MAP_TYPE_REFERENCE);
        }
        catch (IOException e) {
            throw new IpdCustomMetricRegisterException("Couldn't read attributes from MBean for IpdCustomMetric with type " + this.beanType.getName(), e);
        }
    }

    @Override
    public boolean isVisible() {
        return this.isEnabled() && this.jmxRegistered.get();
    }

    @Override
    protected void registerMBean() {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.jmxRegistered.compareAndSet(false, true)) {
            return;
        }
        try {
            this.mBeanServer.registerMBean(this.mBean, this.getObjectName());
        }
        catch (Exception e) {
            throw new IpdCustomMetricRegisterException("Exception occurred while registering MBean for IpdCustomMetric with type " + this.beanType.getName(), e);
        }
    }

    @Override
    protected void unregisterMBean() {
        try {
            if (this.jmxRegistered.compareAndSet(true, false)) {
                this.mBeanServer.unregisterMBean(this.getObjectName());
            }
        }
        catch (Exception e) {
            throw new IpdCustomMetricRegisterException(String.format("Failed to unregister metric %s of type %s", this.getMeterKey(), this.beanType));
        }
    }

    @Override
    public String getTypeId() {
        return this.typeId;
    }

    @Override
    public void update(Consumer<T> updater) {
        if (!this.isEnabled()) {
            return;
        }
        this.registerMBean();
        updater.accept(this.mBean);
        this.metricUpdated();
    }

    private static String getTypeId(Class<?> beanType) {
        return "custom#" + beanType.getName();
    }

    public static <BEAN_TYPE> MeterFactory<CustomMeter<BEAN_TYPE>> factory(Class<BEAN_TYPE> beanType) {
        return CustomMeterImpl.factory(new CustomMeter.MBeanSupplier<BEAN_TYPE>(beanType));
    }

    public static <BEAN_TYPE> MeterFactory<CustomMeter<BEAN_TYPE>> factory(CustomMeter.MBeanSupplier<BEAN_TYPE> mBeanSupplier) {
        return new MeterFactory<CustomMeter<BEAN_TYPE>>(config -> new CustomMeterImpl((MeterConfig)config, mBeanSupplier.createInstance()), CustomMeterImpl.getTypeId(mBeanSupplier.getBeanType()), TYPE_ID);
    }
}

