/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.ipd.api.registry;

import com.atlassian.diagnostics.ipd.api.MeterConfigurations;
import com.atlassian.diagnostics.ipd.api.MeterKey;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.meters.IpdMeter;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterConfig;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterConfigBuilderImpl;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterFactory;
import com.atlassian.diagnostics.ipd.api.meters.config.ProductMeterConfigBuilder;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegisterException;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public abstract class AbstractIpdMeterRegistry
implements IpdRegistry {
    private static final BiConsumer<MeterKey, ProductMeterConfigBuilder> EMPTY_CONSUMER = (ignored1, ignored2) -> {};
    protected final MeterConfigurations meterConfigurations;
    protected final Map<MeterKey, IpdMeter> meters;

    public AbstractIpdMeterRegistry(MeterConfigurations meterConfigurations) {
        this(meterConfigurations, new ConcurrentHashMap<MeterKey, IpdMeter>());
    }

    public AbstractIpdMeterRegistry(MeterConfigurations meterConfigurations, Map<MeterKey, IpdMeter> meters) {
        this.meterConfigurations = meterConfigurations;
        this.meters = meters;
    }

    @Override
    public <T extends IpdMeter> T register(MeterFactory<T> factory, String name, MeterTag ... tags) {
        MeterKey key = new MeterKey(AbstractIpdMeterRegistry.mergeMeterName(name, factory.typeSuffix()), tags);
        IpdMeter ipdMeter = this.meters.computeIfAbsent(key, k -> factory.createMetric(this.evaluateConfig((MeterKey)k)));
        if (ipdMeter.getTypeId().equals(factory.getTypeId())) {
            return (T)ipdMeter;
        }
        throw new IpdRegisterException(String.format("Ipd meter type different than expected, key= %s, expectedType=%s, actualType=%s", ipdMeter.getMeterKey(), factory.getTypeId(), ipdMeter.getTypeId()));
    }

    private MeterConfig evaluateConfig(MeterKey key) {
        MeterConfigBuilderImpl productMeterConfigBuilder = new MeterConfigBuilderImpl();
        this.meterConfigurations.evaluateConfig(key, productMeterConfigBuilder);
        return productMeterConfigBuilder.build(key);
    }

    @Override
    @Nullable
    public IpdMeter get(MeterKey meterKey) {
        return this.meters.get(meterKey);
    }

    @Override
    public void remove(MeterKey meterKey) {
        IpdMeter meter = this.meters.remove(meterKey);
        if (meter != null) {
            meter.close();
        }
    }

    @Override
    public void removeAll() {
        this.meters.values().forEach(IpdMeter::close);
        this.meters.clear();
    }

    @Override
    public void removeAll(String prefix, MeterTag ... tags) {
        Set<MeterTag> tagsSet = Set.of(tags);
        this.removeIf(prefix, meter -> tagsSet.containsAll(List.of(meter.getMeterKey().getTags())));
    }

    @Override
    public void removeAllWithAnyTag(String prefix, Set<MeterTag> tags) {
        this.removeIf(prefix, meter -> !Collections.disjoint(Set.of(meter.getMeterKey().getTags()), tags));
    }

    @Override
    public void removeIf(Predicate<IpdMeter> predicate) {
        this.meters.values().stream().filter(predicate).forEach(IpdMeter::close);
        this.meters.values().removeIf(predicate);
    }

    @Override
    public void removeIf(String prefix, Predicate<IpdMeter> predicate) {
        this.removeIf(meter -> meter.getMeterKey().getName().startsWith(prefix) && predicate.test((IpdMeter)meter));
    }

    @Override
    public void retainIf(String prefix, Predicate<IpdMeter> predicate) {
        this.removeIf(prefix, predicate.negate());
    }

    @Override
    public Collection<IpdMeter> getMeters() {
        return Collections.unmodifiableCollection(this.meters.values());
    }

    @Override
    public Collection<IpdMeter> getMeters(String prefix) {
        return this.meters.values().stream().filter(meter -> meter.getMeterKey().getName().startsWith(prefix)).toList();
    }

    @Override
    public Set<MeterKey> getMeterKeys() {
        return Collections.unmodifiableSet(this.meters.keySet());
    }

    @Override
    public Set<MeterKey> getMeterKeys(String prefix) {
        return this.meters.keySet().stream().filter(key -> key.getName().startsWith(prefix)).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public void unregisterAllDisabledMetrics() {
        this.getMeters().stream().filter(ipdMetric -> !ipdMetric.isEnabled()).forEach(IpdMeter::hideUntilUpdate);
    }

    @Override
    public void shutdown() {
        this.removeAll();
    }

    private static String mergeMeterName(String name, String suffix) {
        if (Strings.isNullOrEmpty((String)suffix)) {
            return name;
        }
        return name + "." + suffix;
    }
}

