/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.buildstatus.event;

import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatusDeletedEvent;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatusSetEvent;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.idx.CommitIndex;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.jira.change.BuildStatusChange;
import com.atlassian.stash.internal.jira.index.scan.JiraIssueScanner;
import com.atlassian.stash.internal.jira.listener.BuildStatusChangeListener;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class BuildStatusEventListener {
    private final BuildStatusChangeListener changeListener;
    private final CommitIndex commitIndex;
    private final JiraIssueScanner jiraIssueScanner;

    public BuildStatusEventListener(BuildStatusChangeListener changeListener, CommitIndex commitIndex, JiraIssueScanner jiraIssueScanner) {
        this.commitIndex = commitIndex;
        this.jiraIssueScanner = jiraIssueScanner;
        this.changeListener = changeListener;
    }

    @EventListener
    public void onRepositoryBuildStatusDeleteEvent(RepositoryBuildStatusDeletedEvent event) {
        this.changeListener.onBuildStatusDeleted(new BuildStatusChange(event.getBuildStatus(), (Set<String>)ImmutableSet.of()));
    }

    @EventListener
    public void onRepositoryBuildStatusSetEvent(RepositoryBuildStatusSetEvent event) {
        RepositoryBuildStatus buildStatus = event.getBuildStatus();
        Set jiraIssueKeys = buildStatus.getCommit().map(Commit::getMessage).filter(StringUtils::isNotBlank).map(this.jiraIssueScanner::scan).orElseGet(() -> {
            PropertyMap propertyMap = this.commitIndex.getProperties(buildStatus.getCommitId(), Collections.singleton("jira-key"));
            if (propertyMap.isEmpty()) {
                return Collections.emptySet();
            }
            return (Set)propertyMap.get((Object)"jira-key");
        });
        this.changeListener.onBuildStatusSet(new BuildStatusChange(buildStatus, jiraIssueKeys));
    }
}

