/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.change;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.stash.internal.jira.change.CommitChangeType;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public class CommitChange {
    private final Commit commit;
    private final Set<String> issueKeys;
    private final CommitChangeType type;

    public CommitChange(@Nonnull Commit commit, @Nonnull CommitChangeType type, @Nonnull Set<String> issueKeys) {
        this.commit = Objects.requireNonNull(commit, "commit");
        this.issueKeys = ImmutableSet.copyOf((Collection)Objects.requireNonNull(issueKeys, "issueKeys"));
        this.type = Objects.requireNonNull(type, "type");
    }

    @Nonnull
    public Commit getCommit() {
        return this.commit;
    }

    @Nonnull
    public Set<String> getIssueKeys() {
        return this.issueKeys;
    }

    @Nonnull
    public CommitChangeType getType() {
        return this.type;
    }
}

