/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.change;

import com.atlassian.bitbucket.dmz.deployments.Deployment;
import com.atlassian.stash.internal.jira.change.DeploymentChangeType;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public class DeploymentChange {
    private final Deployment deployment;
    private final Set<String> issueKeys;
    private final DeploymentChangeType type;

    public DeploymentChange(@Nonnull Deployment deployment, @Nonnull Set<String> issueKeys, @Nonnull DeploymentChangeType type) {
        this.deployment = Objects.requireNonNull(deployment, "deployment");
        this.issueKeys = ImmutableSet.copyOf((Collection)Objects.requireNonNull(issueKeys, "issueKeys"));
        this.type = Objects.requireNonNull(type, "type");
    }

    @Nonnull
    public Deployment getDeployment() {
        return this.deployment;
    }

    @Nonnull
    public Set<String> getIssueKeys() {
        return this.issueKeys;
    }

    @Nonnull
    public DeploymentChangeType getType() {
        return this.type;
    }
}

