/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.stash.internal.jira.cloud.client.CloudClientConfiguration;
import com.atlassian.stash.internal.jira.cloud.client.exception.AccessTokenFetchException;
import com.atlassian.stash.internal.jira.cloud.client.model.AccessTokenRequest;
import com.atlassian.stash.internal.jira.cloud.client.model.AccessTokenResponse;
import com.atlassian.stash.internal.jira.http.json.HttpRequestExecutor;
import com.atlassian.stash.internal.jira.http.json.HttpRequestExecutorFactory;
import jakarta.annotation.Nonnull;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.utils.URIBuilder;

public class AccessTokenClient {
    private static final String ACCESS_TOKEN_ENDPOINT = "/oauth/token";
    private static final String GRANT_TYPE = "client_credentials";
    private final Cache<OAuthConsumerCredentials, AccessTokenResponse> accessTokenCache;
    private final HttpRequestExecutorFactory httpRequestExecutorFactory;
    private final String url;

    public AccessTokenClient(CacheFactory cacheFactory, CloudClientConfiguration cloudClientConfiguration, HttpRequestExecutorFactory httpRequestExecutorFactory) {
        this.url = AccessTokenClient.buildUrl(cloudClientConfiguration.getAtlassianApiUrl());
        this.httpRequestExecutorFactory = httpRequestExecutorFactory;
        this.accessTokenCache = cacheFactory.getCache("com.atlassian.stash.internal.jira.cloud.client.accesstoken", null, new CacheSettingsBuilder().local().expireAfterWrite((long)cloudClientConfiguration.getAccessTokenCacheTtl(), TimeUnit.SECONDS).build());
    }

    public AccessTokenResponse getAccessToken(@Nonnull String clientId, @Nonnull String clientSecret) {
        Objects.requireNonNull(clientId);
        Objects.requireNonNull(clientSecret);
        OAuthConsumerCredentials oAuthConsumerCredentials = new OAuthConsumerCredentials(clientId, clientSecret);
        try {
            AccessTokenResponse cachedAccessToken = (AccessTokenResponse)this.accessTokenCache.get((Object)oAuthConsumerCredentials);
            if (cachedAccessToken != null && !cachedAccessToken.isExpired()) {
                return cachedAccessToken;
            }
            AccessTokenResponse accessTokenResponse = this.fetchAccessToken(oAuthConsumerCredentials);
            this.accessTokenCache.put((Object)oAuthConsumerCredentials, (Object)accessTokenResponse);
            return accessTokenResponse;
        }
        catch (Exception e) {
            String msg = String.format("Unable to fetch access token for client id [%s]", clientId);
            throw new AccessTokenFetchException(msg, e);
        }
    }

    private AccessTokenResponse fetchAccessToken(OAuthConsumerCredentials credentials) {
        HttpRequestExecutor httpRequestExecutor = this.httpRequestExecutorFactory.createAnonymous();
        AccessTokenRequest request = new AccessTokenRequest(credentials.clientId, credentials.clientSecret, GRANT_TYPE);
        return (AccessTokenResponse)httpRequestExecutor.makePostRequest(this.url, request, AccessTokenResponse.class).claim();
    }

    private static String buildUrl(String baseUrl) {
        try {
            return new URIBuilder(baseUrl).setPath(ACCESS_TOKEN_ENDPOINT).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Error while building url", e);
        }
    }

    public static class OAuthConsumerCredentials {
        private final String clientId;
        private final String clientSecret;

        public OAuthConsumerCredentials(String clientId, String clientSecret) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OAuthConsumerCredentials that = (OAuthConsumerCredentials)o;
            return Objects.equals(this.clientId, that.clientId) && Objects.equals(this.clientSecret, that.clientSecret);
        }

        public int hashCode() {
            return Objects.hash(this.clientId, this.clientSecret);
        }
    }
}

