/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client;

import com.atlassian.bitbucket.dmz.resilience.CircuitBreakerService;
import com.atlassian.httpclient.api.Response;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudHttpClient;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudHttpRequest;
import io.atlassian.util.concurrent.Promise;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Supplier;

public class CircuitBreakingHttpClient
implements JiraCloudHttpClient {
    private final CircuitBreakerService circuitBreakerService;
    private final JiraCloudHttpClient delegate;

    public CircuitBreakingHttpClient(CircuitBreakerService circuitBreakerService, JiraCloudHttpClient delegate) {
        this.circuitBreakerService = circuitBreakerService;
        this.delegate = delegate;
    }

    @Override
    @Nonnull
    public Promise<Response> makeDeleteRequest(@Nonnull JiraCloudHttpRequest request) {
        Objects.requireNonNull(request, "request");
        return this.decorateWithCircuitBreaker(request.clientId(), () -> this.delegate.makeDeleteRequest(request));
    }

    @Override
    @Nonnull
    public <T> Promise<T> makeGetRequest(@Nonnull JiraCloudHttpRequest request, @Nonnull Class<T> returnType) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(returnType, "returnType");
        return this.decorateWithCircuitBreaker(request.clientId(), () -> this.delegate.makeGetRequest(request, returnType));
    }

    @Override
    public <T> Promise<T> makePostRequest(@Nonnull JiraCloudHttpRequest request, @Nonnull Class<T> returnType) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(returnType, "returnType");
        return this.decorateWithCircuitBreaker(request.clientId(), () -> this.delegate.makePostRequest(request, returnType));
    }

    private <T> Promise<T> decorateWithCircuitBreaker(String clientId, Supplier<Promise<T>> promiseSupplier) {
        return (Promise)this.circuitBreakerService.decoratePromiseWithCircuitBreaker(this.toCircuitBreakerName(clientId), "jira-site-config", promiseSupplier).get();
    }

    private String toCircuitBreakerName(String clientId) {
        return "jira-site-" + clientId;
    }
}

