/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import jakarta.annotation.Nonnull;

public class CloudClientConfiguration {
    private static final String ACCESS_TOKEN_CACHE_TTL_PROP = "plugin.jira-development-integration.cloud.devinfo.accesstoken.cache.ttl";
    private static final String PERMISSIONS_CACHE_TTL_PROP = "plugin.jira-development-integration..cloud.permissions.cache.ttl";
    private static final String ATLASSIAN_API_URL_PROP = "plugin.jira-development-integration.cloud.devinfo.atlassian.api.url";
    private final ApplicationPropertiesService propertiesService;

    public CloudClientConfiguration(ApplicationPropertiesService propertiesService) {
        this.propertiesService = propertiesService;
    }

    public int getAccessTokenCacheTtl() {
        return this.propertiesService.getPluginProperty(ACCESS_TOKEN_CACHE_TTL_PROP, 3600);
    }

    @Nonnull
    public String getAtlassianApiUrl() {
        return this.propertiesService.getPluginProperty(ATLASSIAN_API_URL_PROP, "https://api.atlassian.com");
    }

    public int getPermissionsCacheTtlSeconds() {
        return this.propertiesService.getPluginProperty(PERMISSIONS_CACHE_TTL_PROP, 3600);
    }
}

