/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.stash.internal.jira.cloud.client.exception.CloudIdResolutionException;
import com.atlassian.stash.internal.jira.cloud.client.model.TenantInfo;
import com.atlassian.stash.internal.jira.http.json.HttpRequestExecutor;
import com.atlassian.stash.internal.jira.http.json.HttpRequestExecutorFactory;
import jakarta.annotation.Nonnull;
import jakarta.ws.rs.core.UriBuilder;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class CloudIdResolvingClient {
    public static final String TENANT_INFO_ENDPOINT = "/_edge/tenant_info";
    private static final long CLOUD_ID_CACHE_EXPIRE_TIME = 1L;
    private static final int CLOUD_ID_CACHE_MAX_ENTRIES = 1000;
    private static final String CLOUD_ID_CACHE_NAME = "com.atlassian.stash.internal.jira.cloud.client.CloudIdResolvingClient.cloudIdCache";
    private final Cache<String, String> cloudIdCache;
    private final HttpRequestExecutorFactory httpRequestExecutorFactory;

    public CloudIdResolvingClient(CacheFactory cacheFactory, HttpRequestExecutorFactory factory) {
        this.cloudIdCache = cacheFactory.getCache(CLOUD_ID_CACHE_NAME, null, new CacheSettingsBuilder().local().expireAfterAccess(1L, TimeUnit.DAYS).maxEntries(1000).build());
        this.httpRequestExecutorFactory = factory;
    }

    public String getCloudId(@Nonnull String jiraSiteUrl) {
        Objects.requireNonNull(jiraSiteUrl);
        if (this.cloudIdCache.containsKey((Object)jiraSiteUrl)) {
            return (String)this.cloudIdCache.get((Object)jiraSiteUrl);
        }
        try {
            String url = UriBuilder.fromUri((String)jiraSiteUrl).path(TENANT_INFO_ENDPOINT).build(new Object[0]).toString();
            HttpRequestExecutor httpRequestExecutor = this.httpRequestExecutorFactory.createAnonymous();
            String cloudId = ((TenantInfo)httpRequestExecutor.makeGetRequest(url, TenantInfo.class).claim()).getCloudId();
            this.cloudIdCache.put((Object)jiraSiteUrl, (Object)cloudId);
            return cloudId;
        }
        catch (Exception ex) {
            String msg = String.format("Unable to resolve Cloud ID for Jira site [%s]", jiraSiteUrl);
            throw new CloudIdResolutionException(msg, ex);
        }
    }
}

