/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client;

import com.atlassian.stash.internal.jira.cloud.client.JiraCloudAuthClient;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudHttpClient;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudHttpRequest;
import com.atlassian.stash.internal.jira.cloud.client.exception.OauthValidationException;
import com.atlassian.stash.internal.jira.cloud.client.model.PermissionsResponse;
import io.atlassian.util.concurrent.Promise;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class DefaultJiraCloudAuthClient
implements JiraCloudAuthClient {
    private final JiraCloudHttpClient jiraCloudHttpClient;

    public DefaultJiraCloudAuthClient(JiraCloudHttpClient jiraCloudHttpClient) {
        this.jiraCloudHttpClient = jiraCloudHttpClient;
    }

    @Override
    public void validateOauthCredentials(@Nonnull String clientId, @Nonnull String clientSecret, @Nonnull String cloudId) throws OauthValidationException {
        Objects.requireNonNull(clientId, "clientId");
        Objects.requireNonNull(clientSecret, "clientSecret");
        Objects.requireNonNull(cloudId, "cloudId");
        try {
            Promise<PermissionsResponse> promise = this.jiraCloudHttpClient.makeGetRequest(JiraCloudHttpRequest.builder().clientId(clientId).clientSecret(clientSecret).endpoint(String.format("/jira/hudson/0.1/apps/%s/capabilities", cloudId)).build(), PermissionsResponse.class);
            promise.claim();
        }
        catch (Exception e) {
            throw new OauthValidationException("Error validating Oauth credentials.", e);
        }
    }
}

