/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.client;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.httpclient.api.Response;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudBuildStatusClient;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudHttpClient;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudHttpRequest;
import com.atlassian.stash.internal.jira.cloud.client.ResponseHandlerService;
import com.atlassian.stash.internal.jira.cloud.client.model.buildstatus.BuildStatusModel;
import com.atlassian.stash.internal.jira.cloud.client.model.buildstatus.BuildStatusRequest;
import com.atlassian.stash.internal.jira.cloud.client.model.buildstatus.SubmitBuildsResponse;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfig;
import com.atlassian.stash.internal.jira.cloud.sync.ModelConverter;
import io.atlassian.util.concurrent.Promise;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class DefaultJiraCloudBuildStatusClient
implements JiraCloudBuildStatusClient {
    private final JiraCloudHttpClient jiraCloudHttpClient;
    private final ResponseHandlerService responseHandlerService;

    public DefaultJiraCloudBuildStatusClient(JiraCloudHttpClient jiraCloudHttpClient, ResponseHandlerService responseHandlerService) {
        this.jiraCloudHttpClient = jiraCloudHttpClient;
        this.responseHandlerService = responseHandlerService;
    }

    @Override
    @Nonnull
    public Promise<Response> deleteBuildStatus(@Nonnull JiraSiteConfig jiraSiteConfig, @Nonnull BuildStatusModel buildStatus) {
        Objects.requireNonNull(jiraSiteConfig, "jiraSiteConfig");
        Objects.requireNonNull(buildStatus, "buildStatus");
        return this.responseHandlerService.handleSuccessOrFail(jiraSiteConfig, this.jiraCloudHttpClient.makeDeleteRequest(JiraCloudHttpRequest.builder().clientId(jiraSiteConfig.getClientId()).clientSecret(jiraSiteConfig.getClientSecret()).endpoint(String.format("/jira/builds/0.1/cloud/%s/pipelines/%s/builds/%s", jiraSiteConfig.getCloudId(), buildStatus.pipelineId(), buildStatus.buildNumber())).build()));
    }

    @Override
    @Nonnull
    public Promise<Response> deleteBuildStatus(@Nonnull JiraSiteConfig jiraSiteConfig, @Nonnull Repository repository) {
        Objects.requireNonNull(jiraSiteConfig, "jiraSiteConfig");
        Objects.requireNonNull(repository, "repository");
        return this.responseHandlerService.handleSuccessOrFail(jiraSiteConfig, this.jiraCloudHttpClient.makeDeleteRequest(JiraCloudHttpRequest.builder().clientId(jiraSiteConfig.getClientId()).clientSecret(jiraSiteConfig.getClientSecret()).endpoint(String.format("/jira/builds/0.1/cloud/%s/bulkByProperties", jiraSiteConfig.getCloudId())).params(ModelConverter.getProperties(repository)).build()));
    }

    @Override
    @Nonnull
    public Promise<SubmitBuildsResponse> sendBuildStatus(@Nonnull JiraSiteConfig jiraSiteConfig, @Nonnull BuildStatusRequest buildStatusRequest) {
        Objects.requireNonNull(jiraSiteConfig, "jiraSiteConfig");
        Objects.requireNonNull(buildStatusRequest, "buildStatusRequest");
        return this.responseHandlerService.handleSuccessOrFail(jiraSiteConfig, this.jiraCloudHttpClient.makePostRequest(JiraCloudHttpRequest.builder().clientId(jiraSiteConfig.getClientId()).clientSecret(jiraSiteConfig.getClientSecret()).endpoint(String.format("/jira/builds/0.1/cloud/%s/bulk", jiraSiteConfig.getCloudId())).requestPayload(buildStatusRequest).build(), SubmitBuildsResponse.class));
    }
}

